/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.function.NumericFunction;
import java.util.ArrayList;

public abstract class BinaryNumericFunction
extends NumericFunction {
    public static final int INVALID_TYPE = -1;

    public BinaryNumericFunction(String fName, byte[][] fAcceptedTypes, byte[][] fResultTypes) {
        super(fName, fAcceptedTypes);
    }

    protected int getIndex(byte cclDType, int argNo) {
        byte[] dataTypes = this.cclArgumentTypes[argNo];
        for (int i = 0; i < dataTypes.length; ++i) {
            if (cclDType != dataTypes[i]) continue;
            return i;
        }
        return -1;
    }

    protected static int getIndex(byte[][] fAcceptedTypes, IDataType iDataType, int argNo) {
        byte[] dataTypes = fAcceptedTypes[argNo];
        for (int i = 0; i < dataTypes.length; ++i) {
            byte dataType = dataTypes[i];
            if (dataType != iDataType.getCCLTypeCode()) continue;
            return i;
        }
        return -1;
    }

    protected static int getPrecision(IDataType lDataType, IDataType rDataType) {
        int lPrecision = lDataType.getPrecision();
        int rPrecision = rDataType.getPrecision();
        int lScale = lDataType.getScale();
        int rScale = rDataType.getScale();
        int maxDiff = Math.max(lPrecision - lScale, rPrecision - rScale);
        int scale = Math.max(lScale, rScale);
        return Math.min(maxDiff + scale + 1, 256);
    }

    @Override
    public void validateArgumentTypesImpl(IDataType[] fArgumentTypes) {
        if (this.getResultDataTypeImpl(fArgumentTypes) == null) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_IncompatibleArgumentTypes, (Object)fArgumentTypes[0].toString(), (Object)fArgumentTypes[1].toString(), (Object)this.getName().toLowerCase());
        }
    }

    protected static void setFormatID(Value result, String keyword, Value left, Value right) {
        FormatService service = FormatService.getInstance();
        ArrayList<FormatId> operandIds = new ArrayList<FormatId>();
        operandIds.add(left.getFormatId());
        operandIds.add(right.getFormatId());
        FormatId resultFormatId = service.formatResult(keyword, operandIds);
        result.setFormatId(resultFormatId);
    }
}

