/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.TableFunction;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.IQueryReuseManager;

public class Cursor
extends TableFunction {
    private static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TEXT_TYPES};

    public Cursor() {
        super("Cursor", ACCEPTED_TYPES, true);
    }

    @Override
    protected IDataType getResultDataTypeImpl(IDataType[] argumentTypes) {
        return DataTypeFactory.getRowType();
    }

    @Override
    public ITabularResultSet execute(XDataContext context, IParameterEvaluator evaluator, IRowsetInfo rowsetInfo) throws XQERuntimeException {
        IQueryReuseManager qrm = context.getEnvironment().getRequestEnvironment().getQueryReuseManager();
        if (qrm == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Incorrect use of Cursor function - missing query reuse manager.");
        }
        Value param = (Value)evaluator.getParameter(context, 0);
        IQueryReuseManager.CursorInfo ci = (IQueryReuseManager.CursorInfo)param.getObject();
        ITabularResultSet iResultSet = qrm.getResultSet(ci, context);
        return iResultSet;
    }
}

