/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.function.DBFunction;
import com.cognos.xqe.function.IDescribe;
import com.cognos.xqe.function.udf.IUDTableFunction;

public class DBTableFunction
extends DBFunction
implements IUDTableFunction {
    static final long serialVersionUID = 539883639050706431L;
    private IDescribe metadata;

    public DBTableFunction(String fName, String fDbName, IDataType fResultType) {
        this(fName, fDbName, fResultType, null);
    }

    public DBTableFunction(String fName, String fDbName, IDataType fResultType, IDataType[] fArgumentTypes) {
        super(fName, fDbName, fResultType, fArgumentTypes);
    }

    public DBTableFunction(String fName, String fDbName, IDescribe fDescribe) {
        this(fName, fDbName, fDescribe, new IDataType[0]);
    }

    public DBTableFunction(String fName, String fDbName, IDescribe fMetaDataObj, IDataType[] fArgumentTypes) {
        super(fName, fDbName, fArgumentTypes);
        this.metadata = fMetaDataObj;
    }

    public DBTableFunction(String fName, String fDbName, IDescribe fMetaDataObj, IDataType[] fArgumentTypes, int fVariableStartIdx) {
        super(fName, fDbName, fArgumentTypes, fVariableStartIdx);
        this.metadata = fMetaDataObj;
    }

    @Override
    public IDataType getResultDataType(SQLTableFunction tableFunc) {
        if (this.resultType == null || null != this.metadata) {
            int nArgs = tableFunc.getNumberChildren();
            int variableStartIdx = this.getVariableStartIndex();
            Object[] args = variableStartIdx > 0 ? new Object[variableStartIdx + 1] : new Object[nArgs];
            Object[] arguments = args;
            for (int i = 0; i < nArgs; ++i) {
                if (i == variableStartIdx) {
                    args[i] = new Object[nArgs - variableStartIdx];
                    args = (Object[])args[i];
                }
                IXQEQueryNode child = tableFunc.getChild(i);
                Object pValue = null;
                if (child.getType() == 301031) {
                    pValue = ((SQLLiteral)child).getValue().getObject();
                }
                args[i] = pValue;
            }
            this.resultType = this.metadata.describe(arguments);
        }
        return this.resultType;
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] argTypes) {
        return this.resultType;
    }

    @Override
    public boolean isTableFunction() {
        return true;
    }

    @Override
    public String[] getArgumentNames() {
        return null;
    }

    @Override
    public String getJarName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClassName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMethodName() {
        throw new UnsupportedOperationException();
    }
}

