/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.character;

import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IAppendable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.StringFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Concat
extends StringFunction {
    public static final String FUNCTION_NAME = "Concat";
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES};

    public Concat() {
        super(FUNCTION_NAME, ACCEPTED_TYPES, true);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Concat.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        if (Concat.checkForOlapMetadata(oDataTypes, 0)) {
            return DataTypeFactory.getVarcharType();
        }
        IDataType lDataType = oDataTypes[0];
        IDataType rDataType = oDataTypes[1];
        if (lDataType == null) {
            return rDataType;
        }
        if (rDataType == null) {
            return lDataType;
        }
        if (lDataType.getCCLTypeCode() == 46) {
            return lDataType;
        }
        if (rDataType.getCCLTypeCode() == 46) {
            return rDataType;
        }
        if (lDataType.getSubType() == DataSubType.BINARYTYPE || rDataType.getSubType() == DataSubType.BINARYTYPE) {
            long lMaxLength = lDataType.getPrecision();
            long rMaxLength = rDataType.getPrecision();
            if (lMaxLength < 0L || rMaxLength < 0L) {
                return DataTypeFactory.getVarBinaryType();
            }
            long maxLength = lMaxLength + rMaxLength;
            if (maxLength > Integer.MAX_VALUE) {
                maxLength = Integer.MAX_VALUE;
            }
            if (lDataType.getCCLTypeCode() == 24 || rDataType.getCCLTypeCode() == 24) {
                return DataTypeFactory.getVarBinaryType((int)maxLength);
            }
            return DataTypeFactory.getBinaryType((int)maxLength);
        }
        if (lDataType.getCCLTypeCode() == 102 || rDataType.getCCLTypeCode() == 102) {
            long rMaxLength;
            long lMaxLength = lDataType.getMaxLength();
            long maxLength = lMaxLength + (rMaxLength = (long)rDataType.getMaxLength());
            if (maxLength > Integer.MAX_VALUE) {
                maxLength = Integer.MAX_VALUE;
            }
            return DataTypeFactory.getArrayType(((ArrayType)lDataType).getElementType(), (int)maxLength);
        }
        long lMaxLength = lDataType.getPrecision();
        long rMaxLength = rDataType.getPrecision();
        if (lMaxLength < 0L || rMaxLength < 0L) {
            return DataTypeFactory.getVarcharType();
        }
        long maxLength = lMaxLength + rMaxLength;
        if (maxLength > Integer.MAX_VALUE) {
            maxLength = Integer.MAX_VALUE;
        }
        return DataTypeFactory.getVarcharType((int)maxLength);
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue output) throws XQERuntimeException {
        Value input1 = (Value)pEvaluator.getParameter(context, 0);
        Value input2 = (Value)pEvaluator.getParameter(context, 1);
        IAppendable outputVal = (IAppendable)output;
        if (input1.isNull() || input2.isNull()) {
            output.setNull();
        } else {
            outputVal.set(input1);
            outputVal.append(input2);
        }
    }
}

