/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.conditional;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.collators.CollatorPoolFactory;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.ITextValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.BooleanFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.runtree.XDataContext;
import java.util.regex.Pattern;

public class Like
extends BooleanFunction {
    private static final String RX_ZERO_OR_MORE = ".*";
    private static final char RX_SINGLE_CHAR = '.';
    private static final char RX_ESCAPE_CHAR = '\\';
    private static final char RX_BINARY_EXPANSION = '*';
    private static final char RX_START_OF_LINE = '^';
    private static final char RX_END_OF_LINE = '$';
    private static final char RX_OPEN_BRACKET = '[';
    private static final char RX_CLOSE_BRACKET = ']';
    private static final char RX_LOGICAL_OR = '|';
    private static final char RX_LEFT_PAREN = '(';
    private static final char RX_RIGHT_PAREN = ')';
    private static final char RX_LEFT_CURLY = '{';
    private static final char RX_RIGHT_CURLY = '}';
    private static final char RX_QUESTION_MARK = '?';
    private static final char RX_PLUS_CHAR = '+';
    private static final char RX_COLUMN_CHAR = ':';
    private static final char SQL_PERCENT = '%';
    private static final char SQL_UNDERSCORE = '_';
    private Pattern regEx;
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TEXT_TYPES, DataTypeCode.ALL_CHARACTER_TYPES, DataTypeCode.ALL_CHARACTER_TYPES};
    protected static final int MAX_ARGS = ACCEPTED_TYPES.length;

    public Like() {
        this("Like");
    }

    public Like(String name) {
        super(name, ACCEPTED_TYPES, false, MAX_ARGS - 1);
    }

    public Like(String name, String syntacticName) {
        super(name, syntacticName, ACCEPTED_TYPES, false, MAX_ARGS - 1);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        int nArgs = pEvaluator.getParameterCount();
        if (pEvaluator.isParameterLiteral(1) && nArgs == 2) {
            this.executeLiteral(context, pEvaluator, outputArg);
        } else if (pEvaluator.isParameterLiteral(1) && nArgs == MAX_ARGS && pEvaluator.isParameterLiteral(2)) {
            this.executeLiteral(context, pEvaluator, outputArg);
        } else {
            this.executeNonLiteral(context, pEvaluator, outputArg);
        }
    }

    private void executeLiteral(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        String expr;
        boolean matched;
        IValue input1 = pEvaluator.getParameter(context, 0);
        Value output = (Value)outputArg;
        if (input1.isNull()) {
            output.setNull();
            return;
        }
        ITextValue expression = (ITextValue)input1;
        if (this.regEx == null) {
            String pattern = this.getPattern(context, pEvaluator);
            if (pattern == null) {
                output.setNull();
                return;
            }
            try {
                this.regEx = Pattern.compile(pattern, Like.getFlags(context));
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
        }
        if (matched = this.regEx.matcher(expr = expression.getString()).matches()) {
            output.set(BooleanValue.TRUE);
        } else {
            output.set(BooleanValue.FALSE);
        }
    }

    private void executeNonLiteral(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        IValue input1 = pEvaluator.getParameter(context, 0);
        Value output = (Value)outputArg;
        if (input1.isNull()) {
            output.setNull();
            return;
        }
        ITextValue expression = (ITextValue)input1;
        String pattern = this.getPattern(context, pEvaluator);
        if (pattern == null) {
            output.setNull();
            return;
        }
        String expr = expression.getString();
        Pattern r = Pattern.compile(pattern, Like.getFlags(context));
        boolean matched = r.matcher(expr).matches();
        if (matched) {
            output.set(BooleanValue.TRUE);
        } else {
            output.set(BooleanValue.FALSE);
        }
    }

    public static int getFlags(XDataContext context) {
        int flags = 32;
        if (context.getLocalCollator().getStrength() < CollatorPoolFactory.CollatorWeight.TERTIARY.getWeight()) {
            flags |= 2;
        }
        return flags;
    }

    private String getPattern(XDataContext context, IParameterEvaluator pEvaluator) {
        IValue input1 = pEvaluator.getParameter(context, 1);
        if (input1.isNull()) {
            return null;
        }
        TextValue pattern = (TextValue)input1;
        TextValue escape = null;
        if (pEvaluator.getParameterCount() == MAX_ARGS) {
            IValue input2 = pEvaluator.getParameter(context, 2);
            if (input2.isNull()) {
                return null;
            }
            escape = (TextValue)input2;
        }
        return Like.likePatternToRegExp(pattern.getString(), escape);
    }

    public static String likePatternToRegExp(String pattern, TextValue escape) {
        boolean escapeOff = escape == null || escape.getCurrentLength() == 0;
        char e = !escapeOff ? (char)escape.getString().charAt(0) : (char)' ';
        return Like.likePatternToRegExp(pattern, e);
    }

    public static String likePatternToRegExp(String pattern, String escape) {
        boolean escapeOff = escape == null || escape.isEmpty();
        char e = !escapeOff ? (char)escape.charAt(0) : (char)' ';
        return Like.likePatternToRegExp(pattern, e);
    }

    public static String likePatternToRegExp(String pattern, char escape) {
        int len = pattern.length();
        if (len == 0) {
            return new String("^$");
        }
        StringBuilder b = new StringBuilder();
        for (int i = len - 1; i >= 0; --i) {
            char c = pattern.charAt(i);
            if (escape == ' ') {
                if (c == '%') {
                    b.insert(0, RX_ZERO_OR_MORE);
                    continue;
                }
                if (c == '_') {
                    b.insert(0, '.');
                    continue;
                }
                b.insert(0, c);
                if (!Like.isSpecial(c)) continue;
                b.insert(0, '\\');
                continue;
            }
            if (c == '%' || c == '_') {
                if (Like.isPreceedingEscape(pattern, i - 1, escape)) {
                    b.insert(0, c);
                    continue;
                }
                if (c == '%') {
                    b.insert(0, RX_ZERO_OR_MORE);
                    continue;
                }
                b.insert(0, '.');
                continue;
            }
            if (c == escape) {
                if (i == 0 || !Like.isPreceedingEscape(pattern, i - 1, escape)) continue;
                b.insert(0, escape);
                continue;
            }
            b.insert(0, c);
            if (!Like.isSpecial(c)) continue;
            b.insert(0, '\\');
        }
        b.insert(0, '^');
        b.append('$');
        return b.toString();
    }

    private static boolean isPreceedingEscape(String s, int index, char escape) {
        if (index < 0) {
            return false;
        }
        char c = s.charAt(index);
        return c == escape;
    }

    private static boolean isSpecial(char c) {
        switch (c) {
            case '$': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '.': 
            case ':': 
            case '?': 
            case '[': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
            case '\\': {
                return true;
            }
        }
        return false;
    }
}

