/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.conditional;

import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.VarcharValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.BooleanFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.runtree.XDataContext;
import java.util.regex.Pattern;

public class Similar
extends BooleanFunction {
    private static final int N_ARGS = 3;
    private Pattern regEx;
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{1, 45, 55, 56}, {1, 45, 55, 56}, {1, 45, 55, 56}};

    public Similar() {
        super("Similar", ACCEPTED_TYPES, false, 2);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue output) throws XQERuntimeException {
        int nArgs = pEvaluator.getParameterCount();
        if (pEvaluator.isParameterLiteral(1) && nArgs == 2) {
            this.executeLiteral(context, pEvaluator, output);
        } else if (pEvaluator.isParameterLiteral(1) && nArgs == 3 && pEvaluator.isParameterLiteral(2)) {
            this.executeLiteral(context, pEvaluator, output);
        } else {
            this.executeNonLiteral(context, pEvaluator, output);
        }
    }

    private void executeLiteral(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        int nArgs = pEvaluator.getParameterCount();
        TextValue expression = (TextValue)pEvaluator.getParameter(context, 0);
        TextValue pattern = (TextValue)pEvaluator.getParameter(context, 1);
        VarcharValue escape = null;
        Value output = (Value)outputArg;
        if (expression.isNull() || pattern.isNull()) {
            output.setNull();
            return;
        }
        if (this.regEx == null) {
            if (nArgs == 3 && (escape = (VarcharValue)pEvaluator.getParameter(context, 2)).isNull()) {
                output.setNull();
                return;
            }
            try {
                this.regEx = Pattern.compile(pattern.getString(), 32);
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
        }
        String expr = expression.getString();
        boolean matched = false;
        try {
            matched = this.regEx.matcher(expr).matches();
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        if (matched) {
            output.set(BooleanValue.TRUE);
        } else {
            output.set(BooleanValue.FALSE);
        }
    }

    private void executeNonLiteral(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        int nArgs = pEvaluator.getParameterCount();
        VarcharValue expression = (VarcharValue)pEvaluator.getParameter(context, 0);
        VarcharValue pattern = (VarcharValue)pEvaluator.getParameter(context, 1);
        VarcharValue escape = null;
        Value output = (Value)outputArg;
        if (expression.isNull() || pattern.isNull()) {
            output.setNull();
            return;
        }
        if (nArgs == 3 && (escape = (VarcharValue)pEvaluator.getParameter(context, 2)).isNull()) {
            output.setNull();
            return;
        }
        String expr = expression.getString();
        Pattern p = Pattern.compile(pattern.getString(), 32);
        boolean matched = p.matcher(expr).matches();
        if (matched) {
            output.set(BooleanValue.TRUE);
        } else {
            output.set(BooleanValue.FALSE);
        }
    }
}

