/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.date;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.function.date.YMDIntBetween;
import com.cognos.xqe.runtree.XDataContext;
import java.util.Date;

public class Age
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{57, 59, 53}};

    public Age() {
        super("Age", ACCEPTED_TYPES, true);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] argumentTypes) {
        return Age.getOutputType(argumentTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return IntegerType.INTEGERTYPE;
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDateType();
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator evaluator, IValue outputArg) throws XQERuntimeException {
        IValue start = evaluator.getParameter(context, 0);
        DateValue end = DataValueFactory.createDateValue();
        end.set(new Date());
        if (start.isNull()) {
            outputArg.setNull();
        } else {
            int result = YMDIntBetween.calculateInterval(end, (DateTimeValue)start, false);
            ((Value)outputArg).set(result);
        }
    }
}

