/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.date;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;

public class DaysBetween
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{57, 59, 53}, {57, 59, 53}};

    public DaysBetween() {
        super("DaysBetween", "days_between", ACCEPTED_TYPES);
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator evaluator, IValue outputArg) throws XQERuntimeException {
        DateTimeValue op1 = (DateTimeValue)evaluator.getParameter(context, 0);
        DateTimeValue op2 = (DateTimeValue)evaluator.getParameter(context, 1);
        if (op1.isNull() || op2.isNull()) {
            outputArg.setNull();
            return;
        }
        DateValue date1 = DataValueFactory.createDateValue();
        date1.copyFrom(op1);
        DateValue date2 = DataValueFactory.createDateValue();
        date2.copyFrom(op2);
        int dif = (int)(DateTimeValue.subtractNoDST(date1.getCalendar(), date2.getCalendar()) / 86400000L);
        ((Value)outputArg).set(dif);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return DaysBetween.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getIntegerType();
    }
}

