/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.date;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;

public class MonthsBetween
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{57, 59, 53}, {57, 59, 53}};

    public MonthsBetween() {
        this("MonthsBetween", "months_between");
    }

    public MonthsBetween(String fName, String fSyntacticName) {
        super(fName, fSyntacticName, ACCEPTED_TYPES);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return MonthsBetween.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getIntegerType();
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator evaluator, IValue outputArg) throws XQERuntimeException {
        DateTimeValue op1 = (DateTimeValue)evaluator.getParameter(context, 0);
        DateTimeValue op2 = (DateTimeValue)evaluator.getParameter(context, 1);
        int flip = 0;
        if (op1.isNull() || op2.isNull()) {
            outputArg.setNull();
            return;
        }
        flip = (int)(op1.getMilliseconds() / 86400000L - op2.getMilliseconds() / 86400000L);
        if (flip > 0) {
            DateTimeValue tempOp = op1;
            op1 = op2;
            op2 = tempOp;
        } else if (flip == 0) {
            ((Value)outputArg).set(0);
            return;
        }
        int year1 = op1.getYear();
        int month1 = op1.getMonth();
        int day1 = op1.getDay();
        int year2 = op2.getYear();
        int month2 = op2.getMonth();
        int day2 = op2.getDay();
        int total = (year2 - year1) * 12;
        if (month1 != month2 || day1 != day2) {
            total = day1 <= day2 || day2 == op2.getCalendar().getActualMaximum(5) ? (total += month2 - month1) : (total += month2 - month1 - 1);
        }
        if (flip > 0) {
            ((Value)outputArg).set(total);
        } else {
            ((Value)outputArg).set(-total);
        }
    }
}

