/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.date;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.PeriodValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.BooleanFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.runtree.XDataContext;

public class PeriodOverlaps
extends BooleanFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{108, 109, 111}, {108, 109, 111}};

    public PeriodOverlaps() {
        super("PeriodOverlaps", ACCEPTED_TYPES, true);
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        Value output = (Value)outputArg;
        PeriodValue period1 = (PeriodValue)pEvaluator.getParameter(context, 0);
        PeriodValue period2 = (PeriodValue)pEvaluator.getParameter(context, 1);
        if (period1.isNull() || period2.isNull()) {
            output.setNull();
            return;
        }
        Boolean result = period1.overlaps(period2);
        if (result == null) {
            output.setNull();
        } else {
            output.set(result);
        }
    }
}

