/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.date;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;

public class QuartersBetween
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{57, 59, 53}, {57, 59, 53}};

    public QuartersBetween() {
        super("QuartersBetween", "quarters_between", ACCEPTED_TYPES);
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator evaluator, IValue outputArg) throws XQERuntimeException {
        DateTimeValue op1 = (DateTimeValue)evaluator.getParameter(context, 0);
        DateTimeValue op2 = (DateTimeValue)evaluator.getParameter(context, 1);
        if (op1.isNull() || op2.isNull()) {
            outputArg.setNull();
            return;
        }
        int y1 = op1.getYear();
        int q1 = op1.getQuarter() - 1;
        int y2 = op2.getYear();
        int q2 = op2.getQuarter() - 1;
        int nQuarters = (y2 - y1) * 4 + q2 - q1;
        ((Value)outputArg).set(-nQuarters);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return QuartersBetween.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getIntegerType();
    }
}

