/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.date;

import com.cognos.i18n.TimeZone;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;

public class ShiftTimeZone
extends ScalarFunction {
    public static final String CANONICAL_NAME = "_shift_timezone";
    public static final int THREE = 3;
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{53, 59}, DataTypeCode.ALL_TEXT_TYPES, DataTypeCode.ALL_TEXT_TYPES};

    public ShiftTimeZone() {
        super("ShiftTimeZone", ACCEPTED_TYPES, 2);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return ShiftTimeZone.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        if (oDataTypes.length == 2) {
            if (oDataTypes[0].getTypeName().equals("timestamp with time zone")) {
                return DataTypeFactory.getTimestampWithTZType();
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidArgumentTypeForNumOfArgs, (Object)oDataTypes[0].getTypeName(), (Object)1, (Object)CANONICAL_NAME);
        }
        if (oDataTypes[0].getTypeName().equals("timestamp")) {
            return DataTypeFactory.getTimestampType();
        }
        throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidArgumentTypeForNumOfArgs, (Object)oDataTypes[0].getTypeName(), (Object)1, (Object)CANONICAL_NAME);
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        IValue input1 = pEvaluator.getParameter(context, 0);
        IValue input2 = pEvaluator.getParameter(context, 1);
        if (pEvaluator.getParameterCount() == 2 && input1 instanceof TimestampWithTZValue) {
            if (!input1.isNull() && !input2.isNull()) {
                String targetTZstr = input2.toString();
                TimestampWithTZValue inputTimestampWithTZ = DataValueFactory.createTimestampWithTZValue();
                inputTimestampWithTZ.copyFrom(input1);
                TimeZone targetTZ = this.getTimeZoneFromID(targetTZstr, 2);
                long targetOffset = targetTZ.getRawOffset();
                if (targetTZ.inDaylightTime(inputTimestampWithTZ.getDate())) {
                    targetOffset += (long)targetTZ.getDSTSavings();
                }
                inputTimestampWithTZ.setTimeZone((int)targetOffset);
                ((TimestampWithTZValue)outputArg).set(inputTimestampWithTZ);
            } else {
                outputArg.setNull();
            }
        } else if (pEvaluator.getParameterCount() == 3 && input1 instanceof TimestampValue) {
            IValue input3 = pEvaluator.getParameter(context, 2);
            if (!(input1.isNull() || input2.isNull() || input3.isNull())) {
                TimestampValue inputTimestamp = DataValueFactory.createTimestampValue();
                inputTimestamp.copyFrom(input1);
                String fromTZstr = input2.toString();
                TimeZone fromTZ = this.getTimeZoneFromID(fromTZstr, 2);
                long fromOffset = fromTZ.getRawOffset();
                TimestampValue fromTimestamp = DataValueFactory.createTimestampValue();
                fromTimestamp.setTimeZone((int)fromOffset);
                fromTimestamp.set(inputTimestamp.getString());
                if (fromTZ.inDaylightTime(fromTimestamp.getDate())) {
                    this.adjustTimestampWhenFoundInNonExistingDstWindow(fromTZ, fromTimestamp);
                    fromOffset += (long)fromTZ.getDSTSavings();
                }
                String targetTZstr = input3.toString();
                TimeZone targetTZ = this.getTimeZoneFromID(targetTZstr, 3);
                long targetOffset = targetTZ.getRawOffset();
                if (targetTZ.inDaylightTime(fromTimestamp.getDate())) {
                    targetOffset += (long)targetTZ.getDSTSavings();
                }
                TimestampValue targetTimestamp = DataValueFactory.createTimestampValue();
                targetTimestamp.setTimeZone((int)targetOffset);
                targetTimestamp.set(fromTimestamp.getString());
                targetTimestamp.addSeconds((int)(-fromOffset) / 1000);
                targetTimestamp.addSeconds((int)targetOffset / 1000);
                ((TimestampValue)outputArg).set(targetTimestamp.getString());
            } else {
                outputArg.setNull();
            }
        } else {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidArgumentTypeForNumOfArgs, (Object)input1.getDataType().getTypeName(), (Object)1, (Object)CANONICAL_NAME);
        }
    }

    private TimeZone getTimeZoneFromID(String tzID, int argPos) {
        TimeZone tzObj = TimeZone.getTimeZone((String)tzID);
        if (tzObj.getID().equals("Etc/Unknown")) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidTimeZoneIdForFunction, (Object)tzID, (Object)argPos, (Object)CANONICAL_NAME);
        }
        return tzObj;
    }

    private void adjustTimestampWhenFoundInNonExistingDstWindow(TimeZone tz, TimestampValue timestamp) {
        if (tz.inDaylightTime(timestamp.getDate())) {
            timestamp.addHours(-1);
            if (!tz.inDaylightTime(timestamp.getDate())) {
                timestamp.addHours(2);
            } else {
                timestamp.addHours(1);
            }
        }
    }
}

