/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.json;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;
import java.util.List;

public class JSONArrayAgg
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES};

    public JSONArrayAgg() {
        super("JSONArrayAgg", ACCEPTED_TYPES, false, 1);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(context);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return DataTypeFactory.getJSONType();
    }

    public static class State
    implements ISetFunctionState {
        private List<IValue> accumulator = new ArrayList<IValue>();
        private int count = 0;

        public State() {
        }

        public State(XDataContext context) {
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            IValue input = pEvaluator.getParameter(context, 0);
            ++this.count;
            if (input.isNull()) {
                return;
            }
            this.accumulator.add((IValue)input.copy());
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void getResult(XDataContext context, IValue output) {
            Value value = (Value)output;
            if (this.count == 0 || this.accumulator.isEmpty()) {
                value.setNull();
            } else {
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append("[");
                int i = 0;
                for (IValue v : this.accumulator) {
                    if (i++ > 0) {
                        sBuilder.append(", ");
                    }
                    Value currentValue = (Value)v;
                    sBuilder.append(currentValue.getJSONLiteral());
                }
                sBuilder.append("]");
                value.set(sBuilder.toString());
            }
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

