/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.json;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.json.JSONFunction;
import com.cognos.xqe.runtree.XDataContext;

public class JSONObject
extends JSONFunction {
    private static final String CLOSE_BRACE = "}";
    private static final String COLON = ":";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String COMMA_SPACE = ", ";
    private static final String OPEN_BRACE = "{";
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{1, 107}, DataTypeCode.ALL_TYPES};

    public JSONObject() {
        super("JSONObject", ACCEPTED_TYPES, true, 1);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        Value output = (Value)outputArg;
        IValue[] values = pEvaluator.getParameters(context);
        boolean absentOnNull = !values[0].isNull() && values[0].toString().equals("ABSENT ON NULL");
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(OPEN_BRACE);
        for (int i = 1; i < values.length; i += 2) {
            Value value = (Value)values[i + 1];
            if (value.isNull() && absentOnNull) continue;
            if (i > 1) {
                sBuilder.append(COMMA_SPACE);
            }
            sBuilder.append(DOUBLE_QUOTE);
            sBuilder.append(values[i]);
            sBuilder.append(DOUBLE_QUOTE);
            sBuilder.append(COLON);
            sBuilder.append(value.getJSONLiteral());
        }
        sBuilder.append(CLOSE_BRACE);
        output.set(sBuilder.toString());
    }
}

