/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.json;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.json.JSONFunction;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.json.JsonPathUtils;

public class JSONValue
extends JSONFunction {
    private static final byte[][] ACCEPTED_TYPES = new byte[][]{{45}, {45, 114}, {1, 107}};
    private static final int VAR_START = ACCEPTED_TYPES.length - 1;

    public JSONValue() {
        super("JSONValue", ACCEPTED_TYPES, true, VAR_START);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] ins) {
        return DataTypeFactory.getVarcharType();
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) {
        Object jsonObj;
        Value output = (Value)outputArg;
        IValue[] values = pEvaluator.getParameters(context);
        IValue content = values[0];
        IValue path = values[1];
        IValue errorOption = values[2];
        try {
            jsonObj = JsonPathUtils.read(content.toString(), path.toString());
        }
        catch (RuntimeException e) {
            if (!errorOption.isNull() && "ERROR ON ERROR".equalsIgnoreCase(errorOption.toString())) {
                throw e;
            }
            jsonObj = null;
        }
        if (jsonObj == null) {
            output.setNull();
        } else {
            output.set(jsonObj);
        }
    }
}

