/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.numeric;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntervalValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.NumericFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Abs
extends NumericFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{2, 4, 6, 8, 10, 11, 12, 17, 60, 107}};

    public Abs() {
        super("Abs", ACCEPTED_TYPES);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Abs.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return oDataTypes[0];
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getSmallintType();
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        IValue input = pEvaluator.getParameter(context, 0);
        if (input.getDataType().isInterval()) {
            IntervalValue output = (IntervalValue)outputArg;
            output.set(input);
            if (!output.isNull()) {
                output.abs();
            }
        } else {
            NumericValue output = (NumericValue)outputArg;
            output.set(input);
            if (!output.isNull()) {
                output.abs();
            }
        }
    }
}

