/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.numeric;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.NumericFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Ceiling
extends NumericFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_NUMERIC_TYPES};

    public Ceiling() {
        super("Ceil", ACCEPTED_TYPES);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Ceiling.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        if (oDataTypes[0] == null) {
            return null;
        }
        IDataType oDataType = oDataTypes[0];
        byte cclType = oDataType.getCCLTypeCode();
        if ((cclType == 12 || cclType == 54) && oDataType.getPrecision() != 0) {
            int precision = Math.min(oDataType.getPrecision() + 1, 256);
            int scale = oDataType.getScale();
            oDataType = DataTypeFactory.getDataType(cclType, precision, scale);
        }
        return oDataType;
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getSmallintType();
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        Value input = (Value)pEvaluator.getParameter(context, 0);
        NumericValue output = (NumericValue)outputArg;
        if (input.isNull()) {
            output.setNull();
            return;
        }
        output.set((NumericValue)input);
        if (!output.isNull()) {
            this.setFormatID("RoundToInteger", input, output);
            output.ceil();
        }
    }
}

