/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.numeric;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.NumericFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Random
extends NumericFunction {
    private static final long DEFAULT_SEED = 12347L;
    private java.util.Random random = new java.util.Random();
    private long previousSeed = 12347L;
    private boolean initSeed = true;
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_NUMERIC_TYPES};

    public Random() {
        super("Random", ACCEPTED_TYPES, false);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Random.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getDoubleType();
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getSmallintType();
    }

    @Override
    public void validateArgumentTypes(IDataType[] fArgumentTypes, boolean strict) throws XQERuntimeException {
        if (null == fArgumentTypes || fArgumentTypes.length == 0) {
            return;
        }
        super.validateArgumentTypes(fArgumentTypes, strict);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        IValue[] parameters = pEvaluator.getParameters(context);
        DoubleValue output = (DoubleValue)outputArg;
        long seed = this.previousSeed;
        if (parameters.length == 1) {
            NumericValue input = (NumericValue)pEvaluator.getParameter(context, 0);
            if (!input.isOK()) {
                output.setState(input.getState());
                return;
            }
            if (seed != input.getLong()) {
                this.initSeed = true;
                seed = input.getLong();
            }
        }
        if (this.initSeed) {
            this.random.setSeed(seed);
            this.initSeed = false;
            this.previousSeed = seed;
        }
        output.set(this.random.nextDouble());
    }
}

