/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.numeric;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.NumericFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Sign
extends NumericFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_NUMERIC_TYPES};

    public Sign() {
        super("Sign", ACCEPTED_TYPES);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Sign.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getIntegerType();
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getSmallintType();
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        Value input = (Value)pEvaluator.getParameter(context, 0);
        NumericValue output = (NumericValue)outputArg;
        if (!input.isOK()) {
            output.setState(input.getState());
            return;
        }
        int sign = ((NumericValue)input).sign();
        output.set(sign);
    }
}

