/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.numeric;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.IScalarFunction;
import com.cognos.xqe.function.NumericFunction;
import com.cognos.xqe.runtree.XDataContext;

public class WidthBucket
extends NumericFunction
implements IScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES, DataTypeCode.ALL_NUMERIC_TYPES};

    public WidthBucket() {
        super("WidthBucket", "width_bucket", ACCEPTED_TYPES);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return WidthBucket.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getIntegerType();
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    public boolean validArgumentTypesImpl(IDataType[] fArgumentTypes) {
        return DataTypeComparator.isComparableTo(fArgumentTypes[0], fArgumentTypes[1]) && DataTypeComparator.isComparableTo(fArgumentTypes[0], fArgumentTypes[2]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        NumericValue operand = (NumericValue)pEvaluator.getParameter(context, 0);
        NumericValue bound1 = (NumericValue)pEvaluator.getParameter(context, 1);
        NumericValue bound2 = (NumericValue)pEvaluator.getParameter(context, 2);
        NumericValue nBuckets = (NumericValue)pEvaluator.getParameter(context, ACCEPTED_TYPES.length - 1);
        NumericValue output = (NumericValue)outputArg;
        if (operand.isNull() || bound1.isNull() || bound2.isNull() || nBuckets.isNull()) {
            output.setNull();
        } else {
            if (bound1.compareTo(bound2) == 0) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "ValueOutOfRange");
            }
            if (bound1.compareTo(bound2) < 0) {
                if (operand.compareTo(bound1) < 0) {
                    output.set(0);
                } else if (operand.compareTo(bound2) >= 0) {
                    output.set(nBuckets.getInteger() + 1);
                } else {
                    DoubleValue temp1 = DataValueFactory.createDoubleValue();
                    DoubleValue temp2 = DataValueFactory.createDoubleValue();
                    temp1.set(operand);
                    temp1.subtract(bound1);
                    temp2.set(bound2);
                    temp2.subtract(bound1);
                    temp1.divide(temp2);
                    temp1.multiply(nBuckets);
                    temp1.increment();
                    temp1.floor();
                    output.set(temp1);
                }
            } else if (operand.compareTo(bound1) > 0) {
                output.set(0);
            } else if (operand.compareTo(bound2) <= 0) {
                output.set(nBuckets.getInteger() + 1);
            } else {
                DoubleValue temp1 = DataValueFactory.createDoubleValue();
                DoubleValue temp2 = DataValueFactory.createDoubleValue();
                temp1.set(bound1);
                temp1.subtract(operand);
                temp2.set(bound1);
                temp2.subtract(bound2);
                temp1.divide(temp2);
                temp1.multiply(nBuckets);
                temp1.increment();
                temp1.floor();
                output.set(temp1);
            }
        }
    }
}

