/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.operator;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.values.IMultiplicable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.BinaryNumericFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.runtree.XDataContext;

public class Multiply
extends BinaryNumericFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{2, 4, 6, 8, 10, 11, 12, 17, 60, 107}, {2, 4, 6, 8, 10, 11, 12, 17, 60, 107}};
    private static final byte[][] RESULT_TYPES = new byte[][]{{4, 6, 8, 8, 11, 11, 12, 17, 60, 0, 0, 0, 0, 0}, {6, 6, 8, 8, 11, 11, 12, 17, 60, 0, 0, 0, 0, 0}, {8, 8, 8, 12, 11, 11, 12, 17, 60, 0, 0, 0, 0, 0}, {12, 12, 12, 12, 11, 11, 12, 17, 60, 0, 0, 0, 0, 0}, {11, 11, 11, 11, 11, 11, 11, 0, 0, 0, 0, 0, 0, 0}, {11, 11, 11, 11, 11, 11, 11, 0, 0, 0, 0, 0, 0, 0}, {12, 12, 12, 12, 11, 11, 12, 0, 0, 0, 0, 0, 0, 0}, {17, 17, 17, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {60, 60, 60, 60, 60, 60, 60, 0, 0, 0, 0, 0, 0, 0}};

    public Multiply() {
        super("Multiply", ACCEPTED_TYPES, RESULT_TYPES);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        if (oDataTypes[0] == null || oDataTypes[1] == null) {
            return null;
        }
        if (oDataTypes[0].isNullType() || oDataTypes[1].isNullType()) {
            return DataTypeFactory.getNullType();
        }
        IDataType result = null;
        IDataType lDataType = oDataTypes[0];
        IDataType rDataType = oDataTypes[1];
        int lDataTypeIndex = Multiply.getIndex(ACCEPTED_TYPES, lDataType, 0);
        int rDataTypeIndex = Multiply.getIndex(ACCEPTED_TYPES, rDataType, 1);
        if (lDataTypeIndex == -1 || rDataTypeIndex == -1) {
            return null;
        }
        byte cclDType = RESULT_TYPES[Multiply.getIndex(ACCEPTED_TYPES, lDataType, 0)][Multiply.getIndex(ACCEPTED_TYPES, rDataType, 1)];
        if (cclDType != 0) {
            if (lDataType.isFloatingPointDecimal() || lDataType.isFloatingPointDecimal()) {
                result = DataTypeFactory.getDataType((byte)12, 0, 0);
            } else if (DataTypeCode.isExactNumeric(cclDType)) {
                int precision = Math.min(lDataType.getPrecision() + rDataType.getPrecision(), 256);
                int scale = lDataType.getScale() + rDataType.getScale();
                result = DataTypeFactory.getDataType(cclDType, precision, scale);
            } else if (lDataType.getCCLTypeCode() == 60 || rDataType.getCCLTypeCode() == 60) {
                IntervalDayTimeType oDataType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_DAY_TO_SECOND);
                oDataType.setLeadingPrecision(9);
                int fSeconds = -1;
                if (lDataType.getCCLTypeCode() == 60) {
                    fSeconds = ((IntervalDayTimeType)lDataType).getFractionalSecondsPrecision();
                }
                if (rDataType.getCCLTypeCode() == 60) {
                    fSeconds = Math.max(((IntervalDayTimeType)rDataType).getFractionalSecondsPrecision(), fSeconds);
                }
                if (fSeconds > -1) {
                    oDataType.setFractionalSecondsPrecision(Math.min(9, fSeconds + 1));
                }
                if (lDataType.getCCLTypeCode() == 60 && rDataType.isNumeric()) {
                    if (oDataType.getQualifier() != ((IntervalType)lDataType).getQualifier()) {
                        oDataType.setQualifier(((IntervalType)lDataType).getQualifier());
                    }
                } else if (lDataType.isNumeric() && rDataType.getCCLTypeCode() == 60 && oDataType.getQualifier() != ((IntervalType)rDataType).getQualifier()) {
                    oDataType.setQualifier(((IntervalType)rDataType).getQualifier());
                }
                result = oDataType;
            } else if (lDataType.getCCLTypeCode() == 17 || rDataType.getCCLTypeCode() == 17) {
                IntervalYearMonthType oDataType = DataTypeFactory.getIntervalYearMonthType(IntervalQualifier.INTERVAL_YEAR_TO_MONTH);
                oDataType.setLeadingPrecision(9);
                if (lDataType.getCCLTypeCode() == 17 && rDataType.isNumeric()) {
                    if (oDataType.getQualifier() != ((IntervalType)lDataType).getQualifier()) {
                        oDataType.setQualifier(((IntervalType)lDataType).getQualifier());
                    }
                } else if (lDataType.isNumeric() && rDataType.getCCLTypeCode() == 17 && oDataType.getQualifier() != ((IntervalType)rDataType).getQualifier()) {
                    oDataType.setQualifier(((IntervalType)rDataType).getQualifier());
                }
                result = oDataType;
            } else {
                result = DataTypeFactory.getDataType(cclDType);
            }
        }
        return result;
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Multiply.getOutputType(oDataTypes);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        IMultiplicable output = (IMultiplicable)outputArg;
        Value input1 = (Value)pEvaluator.getParameter(context, 0);
        Value input2 = (Value)pEvaluator.getParameter(context, 1);
        if (input1.isNull() || input2.isNull()) {
            output.setNull();
        } else {
            output.set(input1);
            output.multiply(input2);
            Multiply.setFormatID((Value)outputArg, "Multiply", input1, input2);
        }
    }
}

