/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.operator;

import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.data.values.ISubtractable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.BinaryNumericFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.runtree.XDataContext;

public class Subtract
extends BinaryNumericFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{2, 4, 6, 8, 10, 11, 12, 17, 60, 59, 58, 57, 53, 52, 107}, {2, 4, 6, 8, 10, 11, 12, 17, 60, 59, 58, 57, 53, 52, 107}};
    private static final byte[][] RESULT_TYPES = new byte[][]{{4, 6, 8, 12, 10, 11, 12, 0, 0, 0, 0, 0, 0, 0}, {6, 6, 8, 12, 10, 11, 12, 0, 0, 0, 0, 0, 0, 0}, {8, 8, 8, 12, 10, 11, 12, 0, 0, 0, 0, 0, 0, 0}, {12, 12, 12, 12, 11, 11, 12, 0, 0, 0, 0, 0, 0, 0}, {10, 10, 10, 11, 11, 11, 11, 0, 0, 0, 0, 0, 0, 0}, {11, 11, 11, 11, 11, 11, 11, 0, 0, 0, 0, 0, 0, 0}, {12, 12, 12, 12, 11, 11, 12, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 59, 59, 60, 0, 0, 60, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 58, 0, 60, 0, 0, 60}, {0, 0, 0, 0, 0, 0, 0, 57, 57, 0, 0, 60, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 53, 53, 60, 0, 0, 60, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 52, 0, 60, 0, 0, 60}};

    public Subtract() {
        super("Subtract", ACCEPTED_TYPES, RESULT_TYPES);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Subtract.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        if (oDataTypes[0] == null || oDataTypes[1] == null) {
            return null;
        }
        if (oDataTypes[0].isNullType() || oDataTypes[1].isNullType()) {
            return DataTypeFactory.getNullType();
        }
        IDataType result = null;
        IDataType lDataType = oDataTypes[0];
        IDataType rDataType = oDataTypes[1];
        if (lDataType.isDate() && rDataType.isTimestamp()) {
            lDataType = TimestampType.TIMESTAMPTYPE;
        }
        int lDataTypeIndex = Subtract.getIndex(ACCEPTED_TYPES, lDataType, 0);
        int rDataTypeIndex = Subtract.getIndex(ACCEPTED_TYPES, rDataType, 1);
        if (lDataTypeIndex == -1 || rDataTypeIndex == -1) {
            return null;
        }
        byte cclDType = RESULT_TYPES[Subtract.getIndex(ACCEPTED_TYPES, lDataType, 0)][Subtract.getIndex(ACCEPTED_TYPES, rDataType, 1)];
        switch (cclDType) {
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                if (lDataType.isFloatingPointDecimal() || lDataType.isFloatingPointDecimal()) {
                    result = DataTypeFactory.getDataType((byte)12, 0, 0);
                    break;
                }
                int precision = Subtract.getPrecision(lDataType, rDataType);
                int scale = Math.max(lDataType.getScale(), rDataType.getScale());
                result = DataTypeFactory.getDataType(cclDType, precision, scale);
                break;
            }
            case 17: {
                result = DataTypeComparator.getCompatibleType(lDataType, rDataType);
                break;
            }
            case 60: {
                if (lDataType.getCCLTypeCode() == 60 && rDataType.getCCLTypeCode() == 60) {
                    result = DataTypeComparator.getCompatibleType(lDataType, rDataType);
                    break;
                }
                if (lDataType.isTime() || rDataType.isTime()) {
                    int precision = -1;
                    IntervalDayTimeType oDataType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_HOUR_TO_SECOND);
                    if (lDataType.isTime()) {
                        precision = ((TimeType)lDataType).getFractionalSecondsPrecision();
                    }
                    if (rDataType.isTime()) {
                        precision = Math.max(precision, ((TimeType)rDataType).getFractionalSecondsPrecision());
                    }
                    if (precision > -1) {
                        oDataType.setFractionalSecondsPrecision(precision);
                    }
                    result = oDataType;
                    break;
                }
                if (lDataType.isDate() || rDataType.isDate()) {
                    result = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_DAY);
                    break;
                }
                if (!lDataType.isTimestamp() && !rDataType.isTimestamp()) break;
                int precision = -1;
                IntervalDayTimeType oDataType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_DAY_TO_SECOND);
                if (lDataType.isTimestamp()) {
                    precision = ((TimestampType)lDataType).getFractionalSecondsPrecision();
                }
                if (rDataType.isTimestamp()) {
                    precision = Math.max(precision, ((TimestampType)rDataType).getFractionalSecondsPrecision());
                }
                if (precision > -1) {
                    oDataType.setFractionalSecondsPrecision(precision);
                }
                result = oDataType;
                break;
            }
            case 57: {
                result = DataTypeFactory.getDataType((byte)57);
                if (lDataType.getCCLTypeCode() != 57 || rDataType.getCCLTypeCode() != 60 || ((IntervalDayTimeType)rDataType).getQualifier() == IntervalQualifier.INTERVAL_DAY) break;
                result = null;
                break;
            }
            case 58: {
                IntervalQualifier qualifier;
                result = DataTypeFactory.getDataType((byte)58);
                if (lDataType.getCCLTypeCode() != 58 || rDataType.getCCLTypeCode() != 60 || (qualifier = ((IntervalDayTimeType)rDataType).getQualifier()) != IntervalQualifier.INTERVAL_DAY && qualifier != IntervalQualifier.INTERVAL_DAY_TO_HOUR && qualifier != IntervalQualifier.INTERVAL_DAY_TO_MINUTE && qualifier != IntervalQualifier.INTERVAL_DAY_TO_SECOND) break;
                result = null;
                break;
            }
            default: {
                result = DataTypeFactory.getDataType(cclDType);
            }
        }
        return result;
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        ISubtractable output = (ISubtractable)outputArg;
        Value input1 = (Value)pEvaluator.getParameter(context, 0);
        Value input2 = (Value)pEvaluator.getParameter(context, 1);
        if (input1.isNull() || input2.isNull()) {
            output.setNull();
        } else {
            output.subtract(input1, input2);
            Subtract.setFormatID((Value)outputArg, "Subtract", input1, input2);
        }
    }
}

