/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.LongValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;
import com.yahoo.sketches.hll.HllSketch;

public class ApproxCountDistinct
extends SetFunction {
    private static final long serialVersionUID = 1L;
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES};

    public ApproxCountDistinct() {
        super("ApproxCountDistinct", "approx_count_distinct", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    public long getVersionID() {
        return 1L;
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return ApproxCountDistinct.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getLongType();
    }

    public static class State
    implements ISetFunctionState {
        private int lgk;
        private final HllSketch hllSketch;
        private int count = 0;

        public State() {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            this.lgk = config.getIntProperty("queryExecution.approxAggregates.lgK[@value]", 12);
            if (this.lgk < 4 || this.lgk > 21) {
                this.lgk = 12;
            }
            this.hllSketch = new HllSketch(this.lgk);
        }

        public State(IDataType type) {
            this();
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) throws XQERuntimeException {
            IValue input = pEvaluator.getParameter(context, 0);
            if (!input.isNull()) {
                if (!input.getDataType().isNumeric()) {
                    this.hllSketch.update(input.toString());
                } else if (input.getDataType().isApproximateNumeric()) {
                    this.hllSketch.update(((NumericValue)input).getDouble());
                } else if (input.getDataType().isDecimal()) {
                    DecimalType type = (DecimalType)input.getDataType();
                    this.hllSketch.update(((DecimalValue)input).getBigDecimal(type.getPrecision(), type.getScale()).unscaledValue().toByteArray());
                } else {
                    this.hllSketch.update(((NumericValue)input).getLong());
                }
                ++this.count;
            }
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) throws XQERuntimeException {
        }

        @Override
        public void getResult(XDataContext context, IValue result) {
            LongValue estimate = DataValueFactory.createLongValue();
            estimate.set(this.hllSketch.getEstimate());
            result.copyFrom(estimate);
        }

        @Override
        public void terminate(XDataContext context) {
        }

        @Override
        public long getCount() {
            return this.count;
        }
    }
}

