/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.ValueComparator;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.function.operator.Divide;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.OrderBy;
import com.cognos.xqe.resultsets.tabular.RowComparator;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.util.SortEngine;

public class CumeDistH
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES};

    public CumeDistH() {
        super("CumeDistH", "cume_dist", ACCEPTED_TYPES, false, 1);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(context, pEvaluator, type, this.getComparator());
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        IntegerType dType = DataTypeFactory.getIntegerType();
        return Divide.getOutputType(new IDataType[]{dType, dType});
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return Divide.getOutputType(oDataTypes);
    }

    protected static class State
    implements ISetFunctionState {
        private int count;
        private SortEngine sortEngine;
        private IDataType inputType;
        private RowValue cumeRowValue = null;
        private RowComparator rowComparator;

        public State(XDataContext context, IParameterEvaluator pEvaluator, IDataType type, ValueComparator comparator) {
            this.inputType = pEvaluator.getParameterType(1);
            RowsetInfo rowsetInfo = new RowsetInfo();
            rowsetInfo.addColumnInfo(new ColumnInfo("inputColumn", this.inputType));
            OrderBy[] orderbyList = new OrderBy[1];
            Boolean isAscending = true;
            if (comparator != null && comparator.getDirection() < 0) {
                isAscending = false;
            }
            orderbyList[0] = new OrderBy(0, isAscending);
            this.rowComparator = new RowComparator(rowsetInfo, orderbyList);
            this.sortEngine = new SortEngine(context, rowsetInfo, this.rowComparator, false);
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            if (this.cumeRowValue == null) {
                IValue[] cumeRow = pEvaluator.getParameters(context);
                this.cumeRowValue = DataValueFactory.createRowValue(cumeRow);
                ++this.count;
                this.sortEngine.write(this.cumeRowValue);
            }
            RowValue inputRow = (RowValue)context.getCurrentRow();
            if (this.cumeRowValue.isNull() || inputRow.isNull()) {
                return;
            }
            ++this.count;
            this.sortEngine.write((IRow)inputRow.copy());
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
        }

        @Override
        public void getResult(XDataContext context, IValue iValue) {
            RowValue v;
            Value value = (Value)iValue;
            if (this.count == 0) {
                value.setNull();
                return;
            }
            RowValue key = this.cumeRowValue;
            int pos = 0;
            for (int i = 1; i <= this.count && (v = (RowValue)this.sortEngine.next()).compareTo(key) <= 0; ++i) {
                ++pos;
            }
            double cume = (double)pos / (double)this.count;
            value.set(cume);
            this.sortEngine.release();
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

