/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.providers.analytics.IForecastProvider;
import com.cognos.xqe.data.providers.analytics.TimeSeriesManager;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class ForecastAggregator
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{4, 6, 8, 10, 11, 12}, {4, 6, 8, 10, 11, 12}, {1}, {4, 6}, {1}};

    public ForecastAggregator() {
        super("Forecast", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State();
    }

    public void setConstantParameters(XDataContext context, ISetFunctionState aggregateState, IParameterEvaluator pEvaluator) {
        State state = (State)aggregateState;
        state.setConstantParameters(context, pEvaluator);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getRowType();
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] argumentTypes) {
        return DataTypeFactory.getDoubleType();
    }

    public static class State
    implements ISetFunctionState {
        private int count = 0;
        private int resultCount = 0;
        private String forecastTypeSpec;
        private int startsAtArgOrdinal = -1;
        private static final String HISTORY_ACTUAL = "Actual";
        private static final String HISTORY_MODELED = "Modeled";
        private static final String HISTORY_NULL = "NULL";
        private HistoricalPeriodValues historyShownAs = HistoricalPeriodValues.MODELED;
        private Vector<Double> allTimeOrdinalValues = new Vector();
        private Vector<Double> allHistoricalValues = new Vector();
        private int lastNonNullValueOrdinal = 0;
        private List forecastResultRows = null;

        @Override
        public long getCount() {
            return this.count;
        }

        private void parseModelSpec(Value modelSpecValue) {
            if (modelSpecValue == null) {
                return;
            }
            if (modelSpecValue.getDataType() != DataTypeFactory.getStringType()) {
                throw new XQERuntimeException(XQEMessageKeys.PRE_ModelSpecTypeError);
            }
            this.forecastTypeSpec = modelSpecValue.getString();
        }

        private void parseStartsAtValue(Value startsAtArgValue) {
            if (startsAtArgValue == null || !startsAtArgValue.isOK()) {
                return;
            }
            if (startsAtArgValue.getDataType() != DataTypeFactory.getIntegerType()) {
                throw new XQERuntimeException(XQEMessageKeys.PRE_StartsAtTypeError);
            }
            this.startsAtArgOrdinal = startsAtArgValue.getInteger();
        }

        private void parseHistoryArgValue(Value historyArgValue) {
            if (historyArgValue == null || !historyArgValue.isOK()) {
                return;
            }
            if (historyArgValue.getDataType() != DataTypeFactory.getStringType()) {
                throw new XQERuntimeException(XQEMessageKeys.PRE_HistoryTypeError);
            }
            String historyArg = historyArgValue.getString();
            if (historyArg.equalsIgnoreCase(HISTORY_ACTUAL)) {
                this.historyShownAs = HistoricalPeriodValues.ACTUAL;
            } else if (historyArg.equalsIgnoreCase(HISTORY_MODELED)) {
                this.historyShownAs = HistoricalPeriodValues.MODELED;
            } else if (historyArg.equalsIgnoreCase(HISTORY_NULL)) {
                this.historyShownAs = HistoricalPeriodValues.NULL;
            }
        }

        public void setConstantParameters(XDataContext context, IParameterEvaluator pEvaluator) {
            if (pEvaluator.getParameterCount() >= Parameter.MODEL_SPEC.ordinal() + 1) {
                this.parseModelSpec((Value)pEvaluator.getParameter(context, Parameter.MODEL_SPEC.ordinal()));
            }
            if (pEvaluator.getParameterCount() >= Parameter.STARTS_AT.ordinal() + 1) {
                Value startsAtArgValue = (Value)pEvaluator.getParameter(context, Parameter.STARTS_AT.ordinal());
                this.parseStartsAtValue(startsAtArgValue);
            }
            if (pEvaluator.getParameterCount() >= Parameter.HISTORY.ordinal() + 1) {
                Value historyArgValue = (Value)pEvaluator.getParameter(context, Parameter.HISTORY.ordinal());
                this.parseHistoryArgValue(historyArgValue);
            }
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            Value measureYValue = (Value)pEvaluator.getParameter(context, 0);
            Value measureXValue = null;
            if (pEvaluator.getParameterCount() >= 2) {
                measureXValue = (Value)pEvaluator.getParameter(context, 1);
            }
            if (measureYValue != null && measureYValue.isOK()) {
                this.allHistoricalValues.add(measureYValue.getDouble());
                this.lastNonNullValueOrdinal = this.count;
            } else {
                this.allHistoricalValues.add(null);
            }
            if (measureXValue != null && measureXValue.isOK()) {
                this.allTimeOrdinalValues.add(measureXValue.getDouble());
            } else {
                this.allTimeOrdinalValues.add(new Double(this.count));
            }
            ++this.count;
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            if (this.resultCount >= this.count) {
                return;
            }
            if (this.forecastResultRows == null) {
                try {
                    this.executeForecast();
                }
                catch (Exception e) {
                    throw new XQERuntimeException(XQEMessageKeys.PRE_ForecastRunError, (Throwable)e);
                }
            }
            if (this.resultCount < this.startsAtArgOrdinal) {
                this.getHistoricalRangeResult((Value)value);
            } else {
                this.assignForecastResult((Value)value);
            }
            ++this.resultCount;
        }

        @Override
        public void terminate(XDataContext context) {
        }

        private void executeForecast() throws Exception {
            Collection executeResult;
            if (this.startsAtArgOrdinal < 0) {
                this.startsAtArgOrdinal = this.lastNonNullValueOrdinal + 1;
            }
            Vector<Double> historicalValues = new Vector<Double>(this.startsAtArgOrdinal);
            historicalValues.addAll(this.allHistoricalValues.subList(0, this.startsAtArgOrdinal));
            Vector<Double> historicalPeriods = new Vector<Double>(this.startsAtArgOrdinal);
            historicalPeriods.addAll(this.allTimeOrdinalValues.subList(0, this.startsAtArgOrdinal));
            IForecastProvider forecastProvider = TimeSeriesManager.getForecastProvider(this.forecastTypeSpec);
            if (this.forecastTypeSpec != null) {
                forecastProvider.prepare(this.forecastTypeSpec);
            }
            this.forecastResultRows = (executeResult = forecastProvider.execute(historicalPeriods, historicalValues, this.allTimeOrdinalValues)) instanceof List ? (List)executeResult : new ArrayList(executeResult);
        }

        private void getHistoricalRangeResult(Value value) {
            if (this.historyShownAs == HistoricalPeriodValues.NULL) {
                value.setNull();
                return;
            }
            if (this.historyShownAs == HistoricalPeriodValues.ACTUAL) {
                this.assignActualValue(value);
                return;
            }
            this.assignForecastResult(value);
        }

        private void assignActualValue(Value value) {
            Double actual = this.allHistoricalValues.get(this.resultCount);
            if (actual == null) {
                value.setNull();
                return;
            }
            byte cclType = value.getDataType().getCCLTypeCode();
            if (cclType == 11) {
                value.set(actual);
            }
            if (cclType == 101) {
                RowValue rowValue = (RowValue)value;
                DoubleValue actualValue = DataValueFactory.createDoubleValue();
                actualValue.set(actual);
                rowValue.setColumn(0, actualValue);
            }
        }

        private void assignForecastResult(Value value) {
            Double forecast = null;
            Double error = null;
            if (this.forecastResultRows.get(this.resultCount) instanceof Double) {
                forecast = (Double)this.forecastResultRows.get(this.resultCount);
            } else if (this.forecastResultRows.get(this.resultCount) instanceof Double[]) {
                Double[] forecastRow = (Double[])this.forecastResultRows.get(this.resultCount);
                if (forecastRow.length > 0) {
                    forecast = forecastRow[0];
                }
                if (forecastRow.length > 1) {
                    error = forecastRow[1];
                }
            }
            if (forecast == null) {
                value.setNull();
                return;
            }
            byte cclType = value.getDataType().getCCLTypeCode();
            if (cclType == 11) {
                value.set(forecast);
            }
            if (cclType == 101) {
                RowValue rowValue = (RowValue)value;
                DoubleValue forecastValue = DataValueFactory.createDoubleValue();
                forecastValue.set(forecast);
                rowValue.setColumn(0, forecastValue);
                DoubleValue forecastError = DataValueFactory.createDoubleValue();
                if (error == null) {
                    forecastError.setNull();
                } else {
                    forecastError.set(error);
                }
                rowValue.setColumn(1, forecastError);
            }
        }

        private static enum HistoricalPeriodValues {
            ACTUAL,
            MODELED,
            NULL;

        }
    }

    public static enum Parameter {
        VALUEY,
        VALUEX,
        MODEL_SPEC,
        STARTS_AT,
        HISTORY;

    }
}

