/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;
import java.util.List;

public class Lag
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES, DataTypeCode.ALL_NUMERIC_TYPES, DataTypeCode.ALL_TYPES, DataTypeCode.ALL_CHARACTER_TYPES};
    private static final int MAX_PARAMETERS = ACCEPTED_TYPES.length;

    public Lag() {
        super("Lag", ACCEPTED_TYPES, true, 1);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType dType) {
        return new State(context, pEvaluator);
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    protected static class State
    implements ISetFunctionState {
        protected int count = 0;
        protected Value resultValue;
        protected int offset;
        protected boolean ignoreNulls = false;
        private Value lastNotNullValue;
        private List<IValue> container = new ArrayList<IValue>();

        public State(XDataContext context, IParameterEvaluator pEvaluator) {
            Value vOffset;
            IDataType dType = pEvaluator.getParameterType(0);
            int nArgs = pEvaluator.getParameterCount();
            this.resultValue = (Value)dType.createValue(context.getLocalCollator());
            this.lastNotNullValue = (Value)dType.createValue(context.getLocalCollator());
            this.offset = nArgs < 2 ? 1 : ((vOffset = (Value)pEvaluator.getParameter(context, 1)).isNull() ? 1 : vOffset.getInteger());
            if (nArgs < MAX_PARAMETERS - 1) {
                this.resultValue.setNull();
            } else {
                this.resultValue.set(pEvaluator.getParameter(context, 2));
            }
            this.lastNotNullValue.copyFrom(this.resultValue);
            if (nArgs < MAX_PARAMETERS) {
                this.ignoreNulls = false;
            } else {
                TextValue nullTreatment = (TextValue)pEvaluator.getParameter(context, MAX_PARAMETERS - 1);
                if (!nullTreatment.isNull() && nullTreatment.getString().equals("IGNORE NULLS")) {
                    this.ignoreNulls = true;
                }
            }
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            Value value = (Value)pEvaluator.getParameter(context, 0);
            ++this.count;
            this.container.add((IValue)value.copy());
            if (this.count > this.offset) {
                if (!this.ignoreNulls) {
                    this.resultValue.copyFrom(this.container.remove(0));
                } else {
                    Value tmpValue = (Value)this.container.remove(0);
                    if (!tmpValue.isNull()) {
                        this.lastNotNullValue = tmpValue;
                        this.resultValue.copyFrom(tmpValue);
                    } else {
                        this.resultValue.copyFrom(this.lastNotNullValue);
                    }
                }
            }
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            value.copyFrom(this.resultValue);
        }

        @Override
        public void terminate(XDataContext context) {
            this.lastNotNullValue.setNull();
        }
    }
}

