/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;
import java.util.List;

public class Lead
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES, DataTypeCode.ALL_NUMERIC_TYPES, DataTypeCode.ALL_TYPES, DataTypeCode.ALL_CHARACTER_TYPES};
    private static final int MAX_PARAMETERS = ACCEPTED_TYPES.length;

    public Lead() {
        super("Lead", ACCEPTED_TYPES, true, 1);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType dType) {
        return new State(context, pEvaluator);
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public boolean isTwoPass() {
        return true;
    }

    protected static class State
    implements ISetFunctionState {
        private int count = 0;
        private Value resultValue;
        private Value defaultValue;
        private Value savedValue;
        private int offset;
        private boolean ignoreNulls = false;
        private List<IValue> container = new ArrayList<IValue>();
        private int numberOfNulls;

        public State(XDataContext context, IParameterEvaluator pEvaluator) {
            Value vOffset;
            IDataType dType = pEvaluator.getParameterType(0);
            int nArgs = pEvaluator.getParameterCount();
            this.defaultValue = (Value)dType.createValue(context.getLocalCollator());
            this.savedValue = (Value)dType.createValue(context.getLocalCollator());
            this.offset = nArgs < 2 ? 1 : ((vOffset = (Value)pEvaluator.getParameter(context, 1)).isNull() ? 1 : vOffset.getInteger());
            if (nArgs < MAX_PARAMETERS - 1) {
                this.defaultValue.setNull();
            } else {
                this.defaultValue.set(pEvaluator.getParameter(context, 2));
            }
            if (nArgs < MAX_PARAMETERS) {
                this.ignoreNulls = false;
            } else {
                TextValue nullTreatment = (TextValue)pEvaluator.getParameter(context, MAX_PARAMETERS - 1);
                if (!nullTreatment.isNull() && nullTreatment.getString().equals("IGNORE NULLS")) {
                    this.ignoreNulls = true;
                }
            }
            this.numberOfNulls = 0;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            Value value = (Value)pEvaluator.getParameter(context, 0);
            if (this.resultValue == null) {
                this.resultValue = (Value)value.getDataType().createValue(context.getLocalCollator());
            }
            ++this.count;
            if (this.count > this.offset) {
                this.container.add((IValue)value.copy());
            }
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            if (this.container.isEmpty()) {
                value.copyFrom(this.defaultValue);
                return;
            }
            if (this.ignoreNulls) {
                if (this.numberOfNulls > 0) {
                    value.copyFrom(this.savedValue);
                    --this.numberOfNulls;
                    return;
                }
                Value aValue = (Value)this.container.remove(0);
                if (!aValue.isNull()) {
                    value.copyFrom(aValue);
                    return;
                }
                while (aValue.isNull() && !this.container.isEmpty()) {
                    ++this.numberOfNulls;
                    aValue = (Value)this.container.remove(0);
                }
                if (this.container.isEmpty()) {
                    value.copyFrom(this.defaultValue);
                    return;
                }
                value.copyFrom(aValue);
                this.savedValue.copyFrom(value);
                return;
            }
            value.copyFrom(this.container.remove(0));
        }

        @Override
        public void terminate(XDataContext context) {
            this.container = null;
            this.savedValue.setNull();
            this.numberOfNulls = 0;
        }
    }
}

