/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Ntile
extends SetFunction {
    private static final byte[][] ACCEPTED_TYPES = new byte[][]{{2, 4, 6, 8}};

    public Ntile() {
        super("Ntile", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State();
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Ntile.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getIntegerType();
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public boolean isTwoPass() {
        return true;
    }

    public static class State
    implements ISetFunctionState {
        private int count = 0;
        private int nBuckets;
        private Behaviour behaviour = new IterationBehaviour();

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            Value value = (Value)pEvaluator.getParameter(context, 0);
            this.behaviour.iterate(value);
            ++this.count;
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            this.behaviour.getResult((IntegerValue)value);
        }

        @Override
        public void terminate(XDataContext context) {
        }

        private class ResultBehaviour
        extends Behaviour {
            int bucketCapacity;
            int extraItems;
            private int currentBucketNo;
            private int itemsInCurrentBucket;

            ResultBehaviour() {
                this.bucketCapacity = State.this.count / State.this.nBuckets;
                this.extraItems = State.this.count % State.this.nBuckets;
                if (this.extraItems > 0) {
                    ++this.bucketCapacity;
                }
                this.currentBucketNo = 1;
                this.itemsInCurrentBucket = 0;
            }

            @Override
            public void iterate(Value theValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void getResult(Value value) {
                if (this.itemsInCurrentBucket == this.bucketCapacity) {
                    this.itemsInCurrentBucket = 0;
                    if (this.extraItems > 0) {
                        --this.extraItems;
                        if (this.extraItems == 0) {
                            --this.bucketCapacity;
                        }
                    }
                    ++this.currentBucketNo;
                }
                value.set(this.currentBucketNo);
                ++this.itemsInCurrentBucket;
            }
        }

        private class IterationBehaviour
        extends Behaviour {
            private IterationBehaviour() {
            }

            @Override
            public void iterate(Value value) {
                State.this.nBuckets = value.getInteger();
            }

            @Override
            public void getResult(Value value) {
                State.this.behaviour = new ResultBehaviour();
                State.this.behaviour.getResult(value);
            }
        }

        private abstract class Behaviour {
            private Behaviour() {
            }

            public abstract void iterate(Value var1);

            public abstract void getResult(Value var1);
        }
    }
}

