/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.ValueComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.OrderBy;
import com.cognos.xqe.resultsets.tabular.RowComparator;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.util.SortEngine;

public class PercentileDisc
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_NUMERIC_TYPES, {4, 6, 8, 10, 11, 12, 60, 17}};

    public PercentileDisc() {
        super("PercentileDisc", "percentile_disc", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(context, pEvaluator, type, this.getComparator());
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return PercentileDisc.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return oDataTypes[1];
    }

    protected static class State
    implements ISetFunctionState {
        private int count;
        private SortEngine sortEngine;
        private IDataType inputType;
        private Value percentileValue = null;
        private RowComparator rowComparator;

        public State(XDataContext context, IParameterEvaluator pEvaluator, IDataType type, ValueComparator comparator) {
            this.inputType = pEvaluator.getParameterType(1);
            RowsetInfo rowsetInfo = new RowsetInfo();
            rowsetInfo.addColumnInfo(new ColumnInfo("inputColumn", this.inputType));
            OrderBy[] orderbyList = new OrderBy[1];
            Boolean isAscending = true;
            if (comparator != null && comparator.getDirection() < 0) {
                isAscending = false;
            }
            orderbyList[0] = new OrderBy(0, isAscending);
            this.rowComparator = new RowComparator(rowsetInfo, orderbyList);
            this.sortEngine = new SortEngine(context, rowsetInfo, this.rowComparator, false);
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            if (this.percentileValue == null) {
                this.percentileValue = (Value)pEvaluator.getParameter(context, 0).copy();
            } else {
                Value tempValue = (Value)pEvaluator.getParameter(context, 0);
                if (!tempValue.equals(this.percentileValue)) {
                    throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidPercentileArgumentType);
                }
            }
            Value input = (Value)pEvaluator.getParameter(context, 1);
            Value aValueForRow = (Value)input.getDataType().createValue();
            aValueForRow.copyFrom(input);
            IValue[] row = new Value[]{aValueForRow};
            RowValue rowValue = DataValueFactory.createRowValue(row);
            if (this.percentileValue.isNull() || input.isNull()) {
                return;
            }
            ++this.count;
            this.sortEngine.write(rowValue);
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
        }

        @Override
        public void getResult(XDataContext context, IValue iValue) {
            Value value = (Value)iValue;
            if (this.count == 0) {
                value.setNull();
                return;
            }
            Comparable<Object> key = (Value)this.sortEngine.next().getColumn(0);
            for (int i = 1; i <= this.count; ++i) {
                Comparable v = null;
                if (i < this.count) {
                    v = (Value)this.sortEngine.next().getColumn(0);
                }
                if (v != null && v.compareTo(key) == 0) continue;
                double d = (double)i / (double)this.count;
                if (d >= this.percentileValue.getDouble()) {
                    value.copyFrom((IValue)key);
                    break;
                }
                if (v == null) continue;
                key = v;
            }
            this.sortEngine.release();
        }

        @Override
        public void terminate(XDataContext context) {
        }

        private void validatePercentileValue() {
            double nv;
            boolean valid = true;
            if (this.percentileValue == null) {
                valid = false;
            } else if (!this.percentileValue.isNull() && ((nv = this.percentileValue.getDouble()) < 0.0 || nv > 1.0)) {
                valid = false;
            }
            if (!valid) {
                throw new XQERuntimeException(XQEMessageKeys.DAT_NumericValueOutOfRange);
            }
        }
    }
}

