/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;

public class RowNumber
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[0][];

    public RowNumber() {
        super("RowNumber", "row_number", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State();
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return RowNumber.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getIntegerType();
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public boolean isTwoPass() {
        return false;
    }

    public static class State
    implements ISetFunctionState {
        private int count = 0;

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            ++this.count;
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            if (this.count <= 0) {
                value.setNull();
            } else {
                ((IntegerValue)value).set(this.count);
            }
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

