/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class SetFunctionsFormatManager {
    private Set<FormatId> distinctFmtIds = new LinkedHashSet<FormatId>();
    private boolean fast = true;
    private short lastId;
    private boolean initialized = false;
    private FormatId cachedFormatId = null;

    public void iterateFormat(Value value) {
        if (this.fast) {
            short formatId = value.getInternalFormatId();
            if (!this.initialized) {
                this.lastId = formatId;
                this.initialized = true;
                return;
            }
            if (this.lastId == formatId) {
                return;
            }
            this.fast = false;
            this.distinctFmtIds.add(FormatId.getInstance(this.lastId));
        }
        this.distinctFmtIds.add(value.getFormatId());
    }

    public void clear() {
        this.initialized = false;
        this.fast = true;
        this.distinctFmtIds.clear();
    }

    public FormatId getResultFormat() {
        if (this.fast) {
            if (this.cachedFormatId == null) {
                this.cachedFormatId = this.calculateFormatId();
            }
            return this.cachedFormatId;
        }
        return this.calculateFormatId();
    }

    protected List<FormatId> getInputFormatIdList() {
        if (this.fast) {
            ArrayList<FormatId> list = new ArrayList<FormatId>();
            if (this.initialized) {
                list.add(FormatId.getInstance(this.lastId));
            }
            return list;
        }
        return new ArrayList<FormatId>(this.distinctFmtIds);
    }

    protected abstract FormatId calculateFormatId();
}

