/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.values.IAddable;
import com.cognos.xqe.data.values.ISubtractable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.function.DistinctSetFunctionState;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.function.operator.Add;
import com.cognos.xqe.function.set.SetFunctionsFormatManager;
import com.cognos.xqe.runtree.XDataContext;

public class Sum
extends SetFunction {
    private static final int MIN_OUTPUT_DECIMAL_PRECISION = 38;
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{4, 6, 8, 10, 11, 12, 17, 60, 107}};

    public Sum() {
        super("Sum", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(context, type, this.isDistinct());
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Sum.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        IDataType dType = Add.getOutputType(new IDataType[]{oDataTypes[0], oDataTypes[0]});
        if (dType instanceof DecimalType) {
            DecimalType decimal = (DecimalType)dType;
            if (decimal.getPrecision() < 38 && decimal.getPrecision() != 0) {
                dType = DataTypeFactory.getDecimalType(38, decimal.getScale());
            }
        } else if (dType instanceof IntegerType) {
            dType = DataTypeFactory.getLongType(dType.getScale());
        }
        return dType;
    }

    public static class SumFormatManager
    extends SetFunctionsFormatManager {
        @Override
        protected FormatId calculateFormatId() {
            FormatService service = FormatService.getInstance();
            return service.formatResult("Sum", this.getInputFormatIdList());
        }
    }

    public static class State
    extends DistinctSetFunctionState {
        private Value sum;
        private int count;
        private int nullCount;
        private SumFormatManager formatManager = new SumFormatManager();

        public State() {
        }

        public State(XDataContext context, IDataType type, boolean isDistinct) {
            super(context, type, isDistinct);
            this.setType(type);
        }

        public void setType(IDataType type) {
            this.sum = (Value)type.createValue();
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        protected void iterateImpl(XDataContext context, IValue input) {
            Value value = (Value)input;
            ++this.count;
            if (value.isNull()) {
                ++this.nullCount;
                return;
            }
            this.formatManager.iterateFormat(value);
            if (value.isDivByZero()) {
                this.sum.setState(ValueState.DIV_BY_ZERO);
            } else if (this.sum.isNull()) {
                this.sum.set(value);
            } else {
                ((IAddable)((Object)this.sum)).add(value);
            }
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            Value input = (Value)pEvaluator.getParameter(context, 0);
            --this.count;
            if (input.isNull()) {
                --this.nullCount;
            } else {
                ((ISubtractable)((Object)this.sum)).subtract(input);
            }
            if (this.count == this.nullCount || this.count == 0) {
                this.sum.setNull();
            }
        }

        @Override
        protected void getResultImpl(XDataContext context, IValue value) {
            this.sum.setFormatId(this.formatManager.getResultFormat());
            value.copyFrom(this.sum);
        }
    }
}

