/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Node;

public class XMLAgg
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{100}, DataTypeCode.ALL_TYPES};

    public XMLAgg() {
        super("XMLAgg", ACCEPTED_TYPES, false, 1);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] ins) {
        return DataTypeFactory.getXmlType();
    }

    public static class State
    implements ISetFunctionState {
        private List<Node> nodeList;
        private int count = 0;
        private int nullCount = 0;

        public State() {
        }

        public State(IDataType type) {
            this.nodeList = new ArrayList<Node>();
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            XmlValue input = (XmlValue)pEvaluator.getParameter(context, 0);
            ++this.count;
            if (input.isNull()) {
                ++this.nullCount;
            }
            if (!input.isNull()) {
                this.nodeList.addAll(input.getNodeList());
            }
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            ((XmlValue)value).set(this.nodeList);
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

