/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set.regression;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.function.BinarySetFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.set.regression.RegrSXY;
import com.cognos.xqe.runtree.XDataContext;

public class CovarSamp
extends BinarySetFunction {
    public CovarSamp() {
        super("CovarSamp", "covar_samp", true);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    protected static class State
    extends RegrSXY.State {
        public State() {
        }

        public State(IDataType type) {
            super(type);
        }

        @Override
        public void getResult(XDataContext context, IValue iValue) {
            NumericValue value = (NumericValue)iValue;
            int n = this.getCardinality();
            if (n == 1) {
                value.setNull();
            } else {
                super.getResult(context, value);
                if (!value.isNull()) {
                    value.set(value.getDouble() / (double)(n - 1));
                }
            }
        }
    }
}

