/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set.regression;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.function.BinarySetFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.runtree.XDataContext;

public class RegrCount
extends BinarySetFunction {
    public RegrCount() {
        super("RegrCount", "regr_count", true);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    protected static class State
    implements ISetFunctionState {
        private int count;
        private int nullCount;

        public State() {
        }

        public State(IDataType type) {
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            NumericValue y = (NumericValue)pEvaluator.getParameter(context, 0);
            NumericValue x = (NumericValue)pEvaluator.getParameter(context, 1);
            ++this.count;
            if (y.isNull() || x.isNull()) {
                ++this.nullCount;
            }
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            NumericValue y = (NumericValue)pEvaluator.getParameter(context, 0);
            NumericValue x = (NumericValue)pEvaluator.getParameter(context, 1);
            --this.count;
            if (y.isNull() || x.isNull()) {
                --this.nullCount;
            }
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            IntegerValue integerValue = DataValueFactory.createIntegerValue(this.count - this.nullCount);
            value.copyFrom(integerValue);
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

