/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set.regression;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.function.BinarySetFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.set.regression.RegrSlope;
import com.cognos.xqe.runtree.XDataContext;

public class RegrIntercept
extends BinarySetFunction {
    public RegrIntercept() {
        super("RegrIntercept", "regr_intercept", true);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    protected static class State
    extends RegrSlope.State {
        public State() {
        }

        public State(IDataType type) {
            super(type);
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            NumericValue pValue = (NumericValue)value;
            int nonNullCount = this.count - this.nullCount;
            if (this.count == 0 || nonNullCount == 0) {
                pValue.setNull();
            } else {
                double d2;
                double d1 = this.sumX.getDouble() * this.sumX.getDouble();
                if (d1 == (d2 = (double)nonNullCount * this.sumX2.getDouble())) {
                    pValue.setNull();
                } else {
                    double result = this.sumY.getDouble() * this.sumX2.getDouble() - this.sumX.getDouble() * this.sumXY.getDouble();
                    pValue.set(result /= d2 - d1);
                }
            }
        }
    }
}

