/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set.regression;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.function.BinarySetFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.runtree.XDataContext;

public class RegrR2
extends BinarySetFunction {
    public RegrR2() {
        super("RegrR2", "regr_r2", true);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    protected static class State
    implements ISetFunctionState {
        private DoubleValue sumX;
        private DoubleValue sumX2;
        private DoubleValue sumY;
        private DoubleValue sumY2;
        private DoubleValue sumXY;
        private int count;
        private int nullCount;

        public State() {
        }

        public State(IDataType type) {
            this.sumX = DataValueFactory.createDoubleValue();
            this.sumX.set(0);
            this.sumX2 = DataValueFactory.createDoubleValue();
            this.sumX2.set(0);
            this.sumY = DataValueFactory.createDoubleValue();
            this.sumY.set(0);
            this.sumY2 = DataValueFactory.createDoubleValue();
            this.sumY2.set(0);
            this.sumXY = DataValueFactory.createDoubleValue();
            this.sumXY.set(0);
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            NumericValue y = (NumericValue)pEvaluator.getParameter(context, 0);
            NumericValue x = (NumericValue)pEvaluator.getParameter(context, 1);
            ++this.count;
            if (y.isNull() || x.isNull()) {
                ++this.nullCount;
                return;
            }
            this.sumX.add(x);
            this.sumY.add(y);
            double d = this.sumXY.getDouble() + x.getDouble() * y.getDouble();
            this.sumXY.set(d);
            d = this.sumX2.getDouble() + x.getDouble() * x.getDouble();
            this.sumX2.set(d);
            d = this.sumY2.getDouble() + y.getDouble() * y.getDouble();
            this.sumY2.set(d);
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            NumericValue y = (NumericValue)pEvaluator.getParameter(context, 0);
            NumericValue x = (NumericValue)pEvaluator.getParameter(context, 1);
            --this.count;
            if (y.isNull() || x.isNull()) {
                --this.nullCount;
            }
            this.sumX.subtract(x);
            this.sumY.subtract(y);
            double d = this.sumXY.getDouble() - x.getDouble() * y.getDouble();
            this.sumXY.set(d);
            d = this.sumX2.getDouble() - x.getDouble() * x.getDouble();
            this.sumX2.set(d);
            d = this.sumY2.getDouble() - y.getDouble() * y.getDouble();
            this.sumY2.set(d);
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            NumericValue pValue = (NumericValue)value;
            int nonNullCount = this.count - this.nullCount;
            if (this.count == 0 || nonNullCount == 0) {
                pValue.setNull();
            } else {
                double d2;
                double d1 = this.sumX.getDouble() * this.sumX.getDouble();
                if (d1 == (d2 = (double)nonNullCount * this.sumX2.getDouble())) {
                    pValue.setNull();
                } else {
                    double d4;
                    double d3 = this.sumY.getDouble() * this.sumY.getDouble();
                    if (d3 == (d4 = (double)nonNullCount * this.sumY2.getDouble())) {
                        pValue.set(1);
                    } else {
                        double result = Math.pow((double)nonNullCount * this.sumXY.getDouble() - this.sumX.getDouble() * this.sumY.getDouble(), 2.0);
                        pValue.set(result /= (d2 - d1) * (d4 - d3));
                    }
                }
            }
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

