/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.udf;

import com.cognos.xqe.ast.sql.ddl.SQLCreateFunction;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.ErrorList;
import com.cognos.xqe.function.IFunctionState;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.udf.UDScalarFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class UDJavaScalarFunction
extends UDScalarFunction
implements IFunctionState {
    static final long serialVersionUID = 539883639050706431L;
    private String jarName;
    private String className;
    private String methodName;
    private Method fMethod;
    private ErrorList errorList;

    public UDJavaScalarFunction(String udfJarName, String udfClassName, String udfMethodName, SQLCreateFunction ddlNode, Method udfMethod, ErrorList udfErrorlist) {
        super(ddlNode);
        this.jarName = udfJarName;
        this.className = udfClassName;
        this.methodName = udfMethodName;
        this.fMethod = udfMethod;
        this.errorList = udfErrorlist;
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) {
        Value pValue;
        int nArgs = pEvaluator.getParameterCount();
        Class<?>[] argClass = this.fMethod.getParameterTypes();
        int nParameters = this.getArgumentCount();
        Object[] args = new Object[nParameters];
        if (this.fMethod.isVarArgs()) {
            --nParameters;
        }
        for (int i = 0; i < nParameters; ++i) {
            pValue = (Value)pEvaluator.getParameter(context, i);
            if (pValue.isNull() && this.callOnNullInput) {
                outputArg.setNull();
                return;
            }
            args[i] = argClass[i].isInstance(pValue) ? pValue : this.getObject(argClass[i], pValue);
        }
        if (this.fMethod.isVarArgs()) {
            Class<?> clazz = argClass[nParameters].getComponentType();
            Object[] arr = (Object[])Array.newInstance(clazz, nArgs - nParameters);
            int k = 0;
            for (int j = nParameters; j < nArgs; ++j) {
                pValue = (Value)pEvaluator.getParameter(context, j);
                arr[k++] = super.getObject(clazz, pValue);
            }
            args[nParameters] = arr;
        }
        try {
            ((Value)outputArg).set(this.fMethod.invoke(null, args));
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    @Override
    public String getJarName() {
        return this.jarName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public boolean isValid() {
        return this.errorList.isEmpty();
    }

    @Override
    public ErrorList getErrors() {
        return this.errorList;
    }
}

