/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.udf;

import com.cognos.xqe.ast.sql.ddl.SQLCreateFunction;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.ErrorList;
import com.cognos.xqe.function.IFunctionState;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.udf.UDAggregateFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class UDScriptAggregateFunction
extends UDAggregateFunction
implements IFunctionState {
    static final long serialVersionUID = 539883639050706431L;
    private static ScriptEngineManager manager = new ScriptEngineManager();
    private Invocable iScriptEngine;
    private ErrorList errorList;

    public UDScriptAggregateFunction(SQLCreateFunction ddlNode, InputStream is, ErrorList udfErrorList) {
        super(ddlNode);
        this.errorList = udfErrorList;
        ScriptEngine scriptEngine = manager.getEngineByName(ddlNode.getLanguage().toLowerCase());
        if (is != null) {
            InputStreamReader reader = new InputStreamReader(is);
            try {
                scriptEngine.eval(reader);
            }
            catch (ScriptException e) {
                this.errorList.add(e.getLocalizedMessage());
            }
        }
        this.iScriptEngine = (Invocable)((Object)scriptEngine);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        Object fStateObj = null;
        try {
            fStateObj = this.iScriptEngine.invokeFunction("initialize", null);
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        return new State(fStateObj);
    }

    @Override
    public boolean isValid() {
        return this.errorList.isEmpty();
    }

    @Override
    public ErrorList getErrors() {
        return this.errorList;
    }

    private class State
    implements ISetFunctionState {
        private int count = 0;
        private Object fStateObj;

        public State(Object stateObj) {
            this.fStateObj = stateObj;
        }

        public Object getStateObject() {
            return this.fStateObj;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            Object[] args = this.getArguments(context, pEvaluator);
            try {
                UDScriptAggregateFunction.this.iScriptEngine.invokeFunction("iterate", args);
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
            ++this.count;
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            Object[] args = this.getArguments(context, pEvaluator);
            try {
                UDScriptAggregateFunction.this.iScriptEngine.invokeFunction("remove", args);
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
            --this.count;
        }

        @Override
        public void getResult(XDataContext context, IValue output) {
            Object result = null;
            try {
                result = UDScriptAggregateFunction.this.iScriptEngine.invokeFunction("getResult", this.fStateObj);
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
            ((Value)output).set(result);
        }

        @Override
        public void terminate(XDataContext context) {
            try {
                UDScriptAggregateFunction.this.iScriptEngine.invokeFunction("terminate", this.fStateObj);
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
        }

        private Object[] getArguments(XDataContext context, IParameterEvaluator pEvaluator) {
            int nArgs = pEvaluator.getParameterCount();
            Object[] args = new Object[nArgs + 1];
            args[0] = this.getStateObject();
            for (int i = 0; i < nArgs; ++i) {
                Value pValue = (Value)pEvaluator.getParameter(context, i);
                args[i + 1] = pValue.isNull() ? null : pValue.getObject();
            }
            return args;
        }
    }
}

