/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.udf;

import com.cognos.xqe.ast.sql.ddl.SQLCreateFunction;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.ErrorList;
import com.cognos.xqe.function.IFunctionState;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.udf.UDScalarFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class UDScriptScalarFunction
extends UDScalarFunction
implements IFunctionState {
    static final long serialVersionUID = 539883639050706431L;
    private static ScriptEngineManager manager = new ScriptEngineManager();
    private ScriptEngine scriptEngine;
    private String methodName;
    private ErrorList errorList;

    public UDScriptScalarFunction(SQLCreateFunction ddlNode, InputStream is, String name, ErrorList udfErrorList) {
        super(ddlNode);
        this.errorList = udfErrorList;
        this.scriptEngine = manager.getEngineByName(ddlNode.getLanguage().toLowerCase());
        if (this.scriptEngine != null && is != null) {
            InputStreamReader reader = new InputStreamReader(is);
            try {
                this.scriptEngine.eval(reader);
            }
            catch (ScriptException e) {
                this.errorList.add(e.getLocalizedMessage());
            }
        }
        this.methodName = name;
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) {
        int nArgs = pEvaluator.getParameterCount();
        Object[] args = new Object[nArgs];
        for (int i = 0; i < nArgs; ++i) {
            Value pValue = (Value)pEvaluator.getParameter(context, i);
            if (pValue.isNull() && this.callOnNullInput) {
                outputArg.setNull();
                return;
            }
            args[i] = pValue.getObject();
        }
        try {
            ((Value)outputArg).set(((Invocable)((Object)this.scriptEngine)).invokeFunction(this.methodName, args));
        }
        catch (ScriptException e) {
            throw XQERuntimeException.wrap(e);
        }
        catch (NoSuchMethodException e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    @Override
    public boolean isValid() {
        return this.errorList.isEmpty();
    }

    @Override
    public ErrorList getErrors() {
        return this.errorList;
    }
}

