/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.xml;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.values.DataLinkValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class XMLUtil {
    public static final String DOCUMENT = "DOCUMENT";
    public static final String CONTENT = "CONTENT";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String PRESERVE_WHITESPACE = "PRESERVE WHITESPACE";
    public static final String STRIP_WHITESPACE = "STRIP WHITESPACE";
    public static final String INCLUDING_XMLDECLARATION = "INCLUDING XMLDECLARATION";
    public static final String EXCLUDING_XMLDECLARATION = "EXCLUDING XMLDECLARATION";
    public static final String NULL_ON_EMPTY = "NULL ON EMPTY";
    public static final String EMPTY_ON_EMPTY = "EMPTY ON EMPTY";
    public static final String NULL_ON_NULL = "NULL ON NULL";
    public static final String EMPTY_ON_NULL = "EMPTY ON NULL";
    public static final String ABSENT_ON_NULL = "ABSENT ON NULL";
    public static final String NIL_ON_NULL = "NIL ON NULL";
    public static final String NIL_ON_NO_CONTENT = "NIL ON NO CONTENT";

    public static Cursor getXCICursor(CursorFactory factory, IValue iValue) throws UnsupportedOperationException {
        StreamSource source = null;
        Value value = (Value)iValue;
        if (value.isNull()) {
            return null;
        }
        switch (value.getDataType().getCCLTypeCode()) {
            case 51: {
                return factory.sequence(value.getBoolean(), null, false);
            }
            case 4: {
                return factory.sequence(value.getShort(), null, false);
            }
            case 6: {
                return factory.sequence(value.getInteger(), null, false);
            }
            case 8: {
                return factory.sequence(value.getLong(), null, false);
            }
            case 10: {
                return factory.sequence(value.getFloat(), null, false);
            }
            case 11: {
                return factory.sequence(value.getDouble(), null, false);
            }
            case 12: {
                return factory.sequence(value.getBigDecimal(), null, false);
            }
            case 1: 
            case 45: 
            case 55: 
            case 56: {
                return factory.sequence((CharSequence)value.getString(), null, false);
            }
            case 100: {
                source = new StreamSource(new StringReader(value.getString()));
                return factory.getSessionContext().document((Source)source, RequestInfo.RANDOM_ACCESS);
            }
            case 48: {
                try {
                    RequestInfo info = new RequestInfo(Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION, new String[]{"STREAMING_XPATH"});
                    source = new StreamSource(((DataLinkValue)value).getURL().openStream());
                    return factory.getSessionContext().document((Source)source, info);
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    public static XSTypeDefinition getXSType(IDataType dType) {
        switch (dType.getCCLTypeCode()) {
            case 51: {
                return TypeRegistry.XSBOOLEAN;
            }
            case 4: {
                return TypeRegistry.XSSHORT;
            }
            case 6: {
                return TypeRegistry.XSINTEGER;
            }
            case 8: {
                return TypeRegistry.XSLONG;
            }
            case 10: {
                return TypeRegistry.XSFLOAT;
            }
            case 11: {
                return TypeRegistry.XSDOUBLE;
            }
            case 12: {
                return TypeRegistry.XSDECIMAL;
            }
            case 1: 
            case 45: 
            case 55: 
            case 56: {
                return TypeRegistry.XSSTRING;
            }
            case 100: {
                return TypeRegistry.XSUNTYPED;
            }
            case 57: {
                return TypeRegistry.XSDATE;
            }
            case 58: {
                return TypeRegistry.XSTIME;
            }
            case 59: {
                return TypeRegistry.XSDATETIME;
            }
            case 17: {
                return XMLUtil.getXSType(((IntervalYearMonthType)dType).getQualifier());
            }
        }
        return TypeRegistry.XSUNTYPED;
    }

    private static XSTypeDefinition getXSType(IntervalQualifier qualifier) {
        switch (qualifier) {
            case INTERVAL_UNKNOWN: {
                return TypeRegistry.XSUNTYPED;
            }
            case INTERVAL_YEAR: {
                return TypeRegistry.XSGYEAR;
            }
            case INTERVAL_MONTH: {
                return TypeRegistry.XSGMONTH;
            }
            case INTERVAL_YEAR_TO_MONTH: {
                return TypeRegistry.XSGYEARMONTH;
            }
            case INTERVAL_DAY: {
                return TypeRegistry.XSGDAY;
            }
        }
        return TypeRegistry.XSDURATION;
    }
}

