/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.hooks;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.ObjectType;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.udf.UDProcedure;
import com.cognos.xqe.hooks.HookEvent;
import com.cognos.xqe.hooks.IHookManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public final class HookManager
implements IHookManager {
    private static XQELogger infoLogger;
    private static HookManager instance;

    public static HookManager instance() {
        return instance;
    }

    private HookManager() {
    }

    @Override
    public void register(HookEvent event, String name) {
        UDProcedure function = (UDProcedure)FunctionManager.getUserDefinedFunction(name, event.getSignature());
        if (function == null) {
            return;
        }
        event.addHook(function.getMethod());
    }

    public static void execute(HookEvent event, Object[] args) throws Exception {
        event.execute(args);
    }

    public static boolean hooksDefined(HookEvent event) {
        return event.hooksDefined();
    }

    static {
        UDProcedure function;
        infoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Configuration", LogLevel.INFO);
        instance = new HookManager();
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (config.getBooleanProperty("general.hooks[@enabled]", false) && (function = (UDProcedure)FunctionManager.getUserDefinedFunction("DQMHOOKS.REGISTER_HOOKS", new IDataType[]{ObjectType.OBJECTTYPE})) != null) {
            try {
                function.getMethod().invoke(null, instance);
            }
            catch (Exception e) {
                infoLogger.log(e);
            }
        }
    }
}

