/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.maExp.MABlockConstraint;
import com.cognos.xqe.ast.maExp.MAConstraint;
import com.cognos.xqe.ast.maExp.MAFDSConstraint;
import com.cognos.xqe.runtree.ma.XMABlockConstraint;
import com.cognos.xqe.runtree.ma.XMAConstraint;
import com.cognos.xqe.runtree.ma.XMAFDSConstraint;
import java.util.ArrayList;
import java.util.List;

public class MAConstraint {
    private String effectiveLocale = null;
    private String firstParam = null;
    private String secondParam = null;
    private String type = null;
    private boolean caseSensitive = true;
    private String condition = null;
    private OperationType constrOperation = OperationType.OPERATION_UNKNOWN;
    private MAConstraint parent = null;
    private List<MAConstraint> constraintChildren = new ArrayList<MAConstraint>();
    private String constraintQueryPath = null;
    private String constNotEqual = "!=";
    private String constAssign = "=";
    private String constStartsWith = "starts-with";
    private String constContains = "contains";
    private String constEndsWith = "ends-with";
    private String constConstraint = "Constraint";
    private String constBlockConstraint = "Blockconstraint";
    private String constNocase = "-nocase";
    private String constSlash = "/";
    private String constLocale = "[locale='";
    private String apos = "'";
    private String aposCloseBracket = "']";

    public MAConstraint() {
        this.type = "root";
        this.effectiveLocale = null;
        this.constrOperation = OperationType.OPERATION_AND;
    }

    public MAConstraint(IXQEQueryNode child, String locale) {
        this.effectiveLocale = locale;
        this.extractProperties(child);
    }

    public String getConstraintType() {
        return this.type;
    }

    public List<MAConstraint> getChildren() {
        return this.constraintChildren;
    }

    public MAConstraint getFirstChild() {
        if (this.constraintChildren.size() == 0) {
            return null;
        }
        return this.constraintChildren.get(0);
    }

    public String getCondition() {
        return this.condition;
    }

    public String getFirstParameter() {
        return this.firstParam;
    }

    public String getSecondParameter() {
        return this.secondParam;
    }

    private void buildQueryPathForEqualTypeOperation(StringBuilder queryPath, String locale, String subString) {
        if (this.firstParam.contains("isFromLinkedSource")) {
            queryPath.append(this.constSlash);
            queryPath.append(this.firstParam);
            queryPath.append("[__Value");
            queryPath.append(subString);
            queryPath.append(this.apos);
            queryPath.append(this.secondParam);
            queryPath.append(this.aposCloseBracket);
        } else {
            queryPath.append(this.constSlash);
            queryPath.append(this.firstParam);
            queryPath.append(this.constLocale);
            queryPath.append(locale);
            queryPath.append("' and  __Value");
            queryPath.append(subString);
            queryPath.append(this.apos);
            queryPath.append(this.secondParam);
            queryPath.append(this.aposCloseBracket);
        }
    }

    private void buildQueryPathForFunctionType(StringBuilder queryPath, String locale, String functionName) {
        queryPath.append(this.constSlash);
        queryPath.append(this.firstParam);
        queryPath.append(this.constLocale);
        queryPath.append(locale);
        queryPath.append("' and ");
        queryPath.append(functionName);
        queryPath.append("(");
        queryPath.append("__Value");
        queryPath.append(",'");
        queryPath.append(this.secondParam);
        queryPath.append("')]");
    }

    public String getConstraintQueryPath() {
        return this.constraintQueryPath;
    }

    public OperationType getOperation() {
        return this.constrOperation;
    }

    private void extractProperties(IXQEQueryNode child) {
        if (child instanceof XMAConstraint) {
            MAConstraint.Function func;
            StringBuilder queryPath = new StringBuilder();
            XMAConstraint xConstraint = (XMAConstraint)child;
            this.firstParam = xConstraint.getLeftOperand();
            this.firstParam = this.firstParam.substring(1);
            this.secondParam = xConstraint.getRightOperand();
            if (this.secondParam != null) {
                this.secondParam = this.secondParam.substring(1, this.secondParam.length() - 1);
            }
            this.type = this.constConstraint;
            this.caseSensitive = xConstraint.isCaseSensitivity();
            MAConstraint.Operation constraintOperation = xConstraint.getOperation();
            if (constraintOperation == MAConstraint.Operation.EQUAL) {
                this.constrOperation = OperationType.OPERATION_EQUAL;
                this.buildQueryPathForEqualTypeOperation(queryPath, this.effectiveLocale, this.constAssign);
            } else if (constraintOperation == MAConstraint.Operation.NOT_EQUAL) {
                this.constrOperation = OperationType.OPERATION_NOT_EQUAL;
                this.buildQueryPathForEqualTypeOperation(queryPath, this.effectiveLocale, this.constNotEqual);
            }
            String casePostfix = "";
            if (!this.caseSensitive) {
                casePostfix = this.constNocase;
            }
            if ((func = xConstraint.getFunction()) == MAConstraint.Function.CONTAINS) {
                this.constrOperation = OperationType.OPERATION_CONTAINS;
                String functionName = this.constContains + casePostfix;
                this.buildQueryPathForFunctionType(queryPath, this.effectiveLocale, functionName);
            } else if (func == MAConstraint.Function.ENDS_WITH) {
                this.constrOperation = OperationType.OPERATION_ENDS_WITH;
                String functionName = this.constEndsWith + casePostfix;
                this.buildQueryPathForFunctionType(queryPath, this.effectiveLocale, functionName);
            } else if (func == MAConstraint.Function.STARTS_WITH) {
                this.constrOperation = OperationType.OPERATION_STARTS_WITH;
                String functionName = this.constStartsWith + casePostfix;
                this.buildQueryPathForFunctionType(queryPath, this.effectiveLocale, functionName);
            }
            this.constraintQueryPath = queryPath.toString();
        } else if (child instanceof XMAFDSConstraint) {
            StringBuilder queryPath = new StringBuilder();
            XMAFDSConstraint xConstraint = (XMAFDSConstraint)child;
            this.firstParam = xConstraint.getConstraint();
            this.firstParam = this.firstParam.substring(1);
            this.secondParam = xConstraint.getValue();
            if (this.secondParam != null) {
                this.secondParam = this.secondParam.substring(1, this.secondParam.length() - 1);
            }
            this.type = this.constConstraint;
            MAFDSConstraint.Operation oper = xConstraint.getOperation();
            if (oper == MAFDSConstraint.Operation.EQUAL) {
                this.constrOperation = OperationType.OPERATION_EQUAL;
                this.buildQueryPathForEqualTypeOperation(queryPath, this.effectiveLocale, this.constAssign);
            } else if (oper == MAFDSConstraint.Operation.NOT_EQUAL) {
                this.constrOperation = OperationType.OPERATION_NOT_EQUAL;
                this.buildQueryPathForEqualTypeOperation(queryPath, this.effectiveLocale, this.constNotEqual);
            }
            this.constraintQueryPath = queryPath.toString();
        } else if (child instanceof XMABlockConstraint) {
            XMABlockConstraint xConstraint = (XMABlockConstraint)child;
            MABlockConstraint.Operation oper = xConstraint.getOperation();
            if (oper == MABlockConstraint.Operation.AND) {
                this.constrOperation = OperationType.OPERATION_AND;
            } else if (oper == MABlockConstraint.Operation.OR) {
                this.constrOperation = OperationType.OPERATION_OR;
            }
            this.type = this.constBlockConstraint;
        }
    }

    public void setParent(MAConstraint constr) {
        this.parent = constr;
    }

    public MAConstraint getParent() {
        return this.parent;
    }

    public void appendChild(MAConstraint constr) {
        this.constraintChildren.add(constr);
    }

    public static enum OperationType {
        OPERATION_UNKNOWN,
        OPERATION_AND,
        OPERATION_OR,
        OPERATION_STARTS_WITH,
        OPERATION_CONTAINS,
        OPERATION_ENDS_WITH,
        OPERATION_EQUAL,
        OPERATION_NOT_EQUAL;

    }
}

