/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ma4j.framework.MAConstraint;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.ma.XMABlockConstraint;
import com.cognos.xqe.runtree.ma.XMAConstraint;
import com.cognos.xqe.runtree.ma.XMAFDSConstraint;
import com.cognos.xqe.runtree.ma.XMAQuery;
import java.util.List;

public class MAConstraintProcessor {
    private MFWGateway mPGW = null;
    private MAConstraint rootConstraint = null;
    private static final String CONSTRAINT = "Constraint";
    private static final String BLOCK_CONSTRAINT = "Blockconstraint";

    public MAConstraintProcessor(MFWGateway pGW) {
        this.mPGW = pGW;
    }

    public boolean evaluate(MFWNodeHandle objectHandle) {
        return this.evaluate(objectHandle, this.rootConstraint);
    }

    private boolean evaluate(MFWNodeHandle objectHandle, MAConstraint constraint) {
        List<MAConstraint> children = constraint.getChildren();
        String queryPath = constraint.getConstraintQueryPath();
        String firstParam = constraint.getFirstParameter();
        String type = constraint.getConstraintType();
        MAConstraint.OperationType constraintOperation = constraint.getOperation();
        if (type.equals(BLOCK_CONSTRAINT) && constraintOperation != MAConstraint.OperationType.OPERATION_OR) {
            constraintOperation = MAConstraint.OperationType.OPERATION_AND;
        }
        boolean result = false;
        switch (constraintOperation) {
            case OPERATION_AND: {
                result = true;
                for (int idx = 0; idx < children.size(); ++idx) {
                    result = result && this.evaluate(objectHandle, children.get(idx));
                }
                break;
            }
            case OPERATION_OR: {
                result = false;
                for (int idx = 0; idx < children.size(); ++idx) {
                    result = result || this.evaluate(objectHandle, children.get(idx));
                }
                break;
            }
            default: {
                result = false;
                if (!this.testExpressionConstraint(objectHandle, queryPath, firstParam)) break;
                result = true;
            }
        }
        return result;
    }

    private boolean testExpressionConstraint(MFWNodeHandle objectHandle, String queryPath, String firstParam) {
        boolean bSuccess = false;
        if (objectHandle.getInfo().findChildInfo(firstParam) == null) {
            return bSuccess;
        }
        MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)queryPath);
        MFWNodeHandle[] handles = null;
        handles = this.mPGW.queryObject(objectHandle, aQuerySpec);
        if (handles != null && handles.length > 0) {
            bSuccess = true;
        }
        return bSuccess;
    }

    public void buildCOnstraintsTreeFromConstraintRunTree(XMAQuery xmaQuery, XDataContext context, String locale) {
        IXQEQueryNode[] children;
        this.rootConstraint = new MAConstraint();
        for (IXQEQueryNode child : children = xmaQuery.getChildren()) {
            String type = this.calcConstraintType(child);
            MAConstraint newConstraint = null;
            if (type == null) continue;
            newConstraint = new MAConstraint(child, locale);
            newConstraint.setParent(this.rootConstraint);
            this.rootConstraint.appendChild(newConstraint);
            if (!type.equals(BLOCK_CONSTRAINT)) continue;
            this.processChildNode(newConstraint, child, locale);
        }
    }

    public boolean hasConstraints() {
        List<MAConstraint> constraints;
        return this.rootConstraint != null && (constraints = this.rootConstraint.getChildren()).size() > 0;
    }

    public MAConstraint getConstraint() {
        return this.rootConstraint;
    }

    private void processChildNode(MAConstraint parentConstraint, IXQEQueryNode parent, String locale) {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = parent.getChildren()) {
            String type = this.calcConstraintType(child);
            MAConstraint newConstraint = null;
            if (type != null) {
                newConstraint = new MAConstraint(child, locale);
                newConstraint.setParent(parentConstraint);
                parentConstraint.appendChild(newConstraint);
            }
            if (!type.equals(BLOCK_CONSTRAINT)) continue;
            this.processChildNode(newConstraint, child, locale);
        }
    }

    private String calcConstraintType(IXQEQueryNode child) {
        String type = null;
        if (child instanceof XMAConstraint) {
            type = CONSTRAINT;
        } else if (child instanceof XMABlockConstraint) {
            type = BLOCK_CONSTRAINT;
        } else if (child instanceof XMAFDSConstraint) {
            type = CONSTRAINT;
        }
        return type;
    }
}

