/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.ma4j.framework.MACollectionElement;
import com.cognos.xqe.ma4j.framework.MAMetadataParameters;
import com.cognos.xqe.ma4j.framework.MAQueryParser;
import com.cognos.xqe.ma4j.framework.MAQueryProcessor;
import com.cognos.xqe.runtree.ma.MAXNodeRuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class MAPropertyParser {
    private Set<String> mProperties = new TreeSet<String>();
    private Set<String> mPropertiesForShortcuts = new TreeSet<String>();
    private Set<String> mVirtualProperties = new TreeSet<String>();
    private Map<String, Set<String>> mRestrictedProperties = new TreeMap<String, Set<String>>();
    private Set<String> mSpecialProperties = new TreeSet<String>();
    private Map<String, ArrayList<String>> mCollections = new HashMap<String, ArrayList<String>>();
    private Set<String> mVirtualPropertiesNames = new TreeSet<String>();
    private Set<String> mAllowedSiblings = new HashSet<String>();
    private MAQueryProcessor mQueryProcessor = new MAQueryProcessor();
    private MFWModel mModel = null;
    private final String namespace = "namespace";
    private final String folder = "folder";
    private final String dotSlash = "./";
    private final String amper = "@";
    private final String shortcut = "shortcut";
    private final String slash = "/";
    private String querySubject = "querySubject";
    private final String dimension = "dimension";
    private final String path = "_path";
    private final String ref = "_ref";
    private String[] allowedSiblings = new String[]{this.querySubject, "queryItem", "queryItemFolder", "calculation", "filter", "function", "shortcut", "dimension", "hierarchy", "level", "measure", "measureFolder", "hierarchyFolder", "relationship", "key", "index", "relationshipShortcut", "parameterMaps", "paramerMap", "parameterMapEntry", "procParameter", "queryItemMap", "securityViews", "securityView", "dataItem", "previewFilter", "filterDefinition", "relationshipDefinition", "embeddedRelationship", "securityFilterDefinition", "set", "securityObject", "basedOn", "datasource", "functionSet", "member", "scopeRelationship", "scope", "measureScope", "role", "qosOverride", "determinant"};

    public MAPropertyParser() {
        this.mModel = MFWModel.getInstance();
        this.initializeVirtualPropertiesNames();
        this.initializePropertiesForShortcuts();
        this.prepareAllowedSiblings();
    }

    public void parseProperties(ArrayList<String> queryStrings, String rootCollectionName, MAQueryParser queryParser, boolean buildTree) {
        MAMetadataParameters metadataParameters;
        int k;
        int size;
        if (rootCollectionName != null && rootCollectionName.length() > 0) {
            if (rootCollectionName.compareTo("namespace") == 0) {
                rootCollectionName = "folder";
            }
            boolean found = false;
            size = queryStrings.size();
            for (k = 0; k < size; ++k) {
                String collection = queryStrings.get(k);
                if (!collection.endsWith(rootCollectionName)) continue;
                found = true;
                break;
            }
            if (!found) {
                String collectionName = "./" + rootCollectionName;
                queryStrings.add(collectionName);
            }
        }
        if ((metadataParameters = queryParser.getMetadataParameters()) != null) {
            this.mVirtualProperties = metadataParameters.getInternalProperties();
            this.mRestrictedProperties = metadataParameters.getRestrictedProperties();
            this.mProperties = metadataParameters.getPlainProperties();
            this.mSpecialProperties = metadataParameters.getGlobalProperties();
            HashSet<String> buffer = new HashSet<String>();
            for (String name : this.mProperties) {
                if (!this.verifyElement(name)) continue;
                buffer.add(name);
            }
            this.mProperties = buffer;
            Set<String> collections = metadataParameters.getCollections();
            boolean rootProvided = rootCollectionName != null && rootCollectionName.length() > 0;
            boolean foundRootName = false;
            for (String name : collections) {
                if (rootProvided && rootCollectionName.equals(name)) {
                    foundRootName = true;
                }
                ArrayList<String> children = new ArrayList<String>();
                String[] tokens = name.split("/");
                if (!this.verifyElement(name = tokens[0])) continue;
                boolean correct = true;
                for (int t = 0; t < tokens.length; ++t) {
                    if (!this.verifyElement(tokens[t])) {
                        correct = false;
                        break;
                    }
                    children.add(tokens[t]);
                }
                if (!correct) continue;
                ArrayList<String> old = this.mCollections.get(name);
                if (old != null) {
                    ArrayList<String> newChildren = new ArrayList<String>(children);
                    for (String oldChild : old) {
                        boolean found = false;
                        for (String newChild : children) {
                            if (!newChild.equals(oldChild)) continue;
                            found = true;
                        }
                        if (found) continue;
                        newChildren.add(oldChild);
                    }
                    this.mCollections.put(name, newChildren);
                    continue;
                }
                this.mCollections.put(name, children);
            }
            if (rootProvided && !foundRootName) {
                ArrayList<String> children = new ArrayList<String>();
                children.add(rootCollectionName);
                this.mCollections.put(rootCollectionName, children);
            }
        } else {
            size = queryStrings.size();
            for (k = 0; k < size; ++k) {
                String[] tokens;
                String item = queryStrings.get(k);
                if (item.indexOf("@") != -1) {
                    String prop = item.replaceAll("@", "");
                    if (prop.startsWith("./")) {
                        prop = prop.substring(2);
                    }
                    if (prop.startsWith("*/")) {
                        if ((prop = prop.substring(2)).equals("isNamespace")) {
                            this.mProperties.add(prop);
                            continue;
                        }
                        if (!this.verifyElement(prop)) continue;
                        this.mProperties.add(prop);
                        continue;
                    }
                    if (prop.startsWith("/")) {
                        prop = prop.substring(1);
                        this.mSpecialProperties.add(prop);
                        continue;
                    }
                    String[] tokens2 = prop.split("/");
                    if (tokens2.length != 2) continue;
                    String parentName = tokens2[0];
                    String propName = tokens2[1];
                    if (!this.verifyElement(propName)) continue;
                    if (this.verifyElement(parentName)) {
                        Set<String> names = this.mRestrictedProperties.get(parentName);
                        if (names == null) {
                            names = new HashSet<String>();
                            names.add(propName);
                            this.mRestrictedProperties.put(parentName, names);
                            continue;
                        }
                        if (names.contains(propName)) continue;
                        names.add(propName);
                        continue;
                    }
                    throw new MAXNodeRuntimeException(XQEMessageKeys.MA_WrongProperty, propName);
                }
                if (item.startsWith("./")) {
                    item = item.substring(2);
                }
                if (!this.verifyElement((tokens = item.split("/"))[0])) continue;
                ArrayList<String> children = new ArrayList<String>();
                boolean correct = true;
                for (int t = 0; t < tokens.length; ++t) {
                    if (!this.verifyElement(tokens[t])) {
                        correct = false;
                        break;
                    }
                    children.add(tokens[t]);
                }
                if (!correct) continue;
                this.mCollections.put(tokens[0], children);
            }
            ArrayList<String> shortcuts = new ArrayList<String>();
            shortcuts.add("shortcut");
            this.mCollections.put("shortcut", shortcuts);
            for (String name : this.mProperties) {
                if (!this.isVirtualProperty(name)) continue;
                this.mVirtualProperties.add(name);
            }
            for (String name : this.mVirtualProperties) {
                this.mProperties.remove(name);
            }
        }
        Set<String> collectionKeys = this.mCollections.keySet();
        boolean containsqs = collectionKeys.contains(this.querySubject);
        boolean containsdim = collectionKeys.contains("dimension");
        if (containsqs && !containsdim) {
            String objectToAdd = "dimension";
            this.addDefaultObj(objectToAdd);
        }
        if (buildTree) {
            this.mQueryProcessor.setCollections(this.mCollections);
            this.mQueryProcessor.buildAncestryTree(rootCollectionName);
        }
    }

    private void addDefaultObj(String objectToAdd) {
        if (objectToAdd != null) {
            ArrayList<String> objects = new ArrayList<String>();
            objects.add(objectToAdd);
            this.mCollections.put(objectToAdd, objects);
        }
    }

    public Map<String, ArrayList<String>> getRequestedCollection() {
        return this.mCollections;
    }

    public MACollectionElement getCollectionsTree() {
        return this.mQueryProcessor.getCollectionsTree();
    }

    public boolean findCollection(String name) {
        if (name.compareTo("namespace") == 0) {
            name = "folder";
        }
        if (name.compareTo("dimension") == 0) {
            name = this.querySubject;
        }
        return this.mCollections.containsKey(name);
    }

    public boolean findRestrictedProperty(String parentName, String propretyName) {
        Set<String> obj = this.mRestrictedProperties.get(parentName);
        return obj != null && obj.contains(propretyName);
    }

    public boolean findProperty(String propName) {
        return this.mProperties.contains(propName);
    }

    public boolean findSpecialProperty(String propName) {
        return this.mSpecialProperties.contains(propName);
    }

    public boolean findProperty(String parentName, String propertyName) {
        if (this.findProperty(propertyName)) {
            return true;
        }
        return this.findRestrictedProperty(parentName, propertyName);
    }

    public boolean findVirtualProperty(String propName) {
        return this.mVirtualProperties.contains(propName);
    }

    public Set<String> getProperties() {
        return this.mProperties;
    }

    public Set<String> getVirtualProperties() {
        return this.mVirtualProperties;
    }

    public Set<String> getSpecialProperties() {
        return this.mSpecialProperties;
    }

    public Set<String> getShortcutProperties() {
        return this.mPropertiesForShortcuts;
    }

    public Set<String> getRestrictedProperties(String parentName) {
        Set<String> names = this.mRestrictedProperties.get(parentName);
        return names;
    }

    public Map<String, Set<String>> getRestrictedProperties() {
        return this.mRestrictedProperties;
    }

    public void initialize() {
        this.mProperties.clear();
        this.mRestrictedProperties.clear();
        this.mSpecialProperties.clear();
        this.mCollections.clear();
    }

    private void initializeVirtualPropertiesNames() {
        this.mVirtualPropertiesNames.clear();
        this.mVirtualPropertiesNames.add("_path");
        this.mVirtualPropertiesNames.add("_ref");
        this.mVirtualPropertiesNames.add("_scopeLevels");
        this.mVirtualPropertiesNames.add("_effectivePromptInfo");
        this.mVirtualPropertiesNames.add("_parent");
        this.mVirtualPropertiesNames.add("_ancestors");
        this.mVirtualPropertiesNames.add("_siblings");
        this.mVirtualPropertiesNames.add("queryItemMapEntry");
    }

    private void initializePropertiesForShortcuts() {
        this.mPropertiesForShortcuts.clear();
        this.mPropertiesForShortcuts.add("_path");
        this.mPropertiesForShortcuts.add("_ref");
        this.mPropertiesForShortcuts.add("name");
        this.mPropertiesForShortcuts.add("screenTip");
        this.mPropertiesForShortcuts.add("description");
    }

    private boolean isVirtualProperty(String propName) {
        return this.mVirtualPropertiesNames.contains(propName);
    }

    public boolean isShortcutSpecificProperty(String propName) {
        return this.mPropertiesForShortcuts.contains(propName);
    }

    private boolean verifyElement(String name) {
        if (!this.isVirtualProperty(name)) {
            short ridName = MFWModelRes.getInstance().getResourceID(name);
            return this.mModel.findInfoByRID(ridName) != null;
        }
        return true;
    }

    private void prepareAllowedSiblings() {
        for (int k = 0; k < this.allowedSiblings.length; ++k) {
            String name = this.allowedSiblings[k];
            this.mAllowedSiblings.add(name);
        }
    }

    public boolean findAllowedSibling(String name) {
        return this.mAllowedSiblings.contains(name);
    }
}

