/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.ma4j.framework.MACollectionElement;
import com.cognos.xqe.ma4j.framework.MAConstraint;
import com.cognos.xqe.ma4j.framework.MAConstraintProcessor;
import com.cognos.xqe.ma4j.framework.MAFunctionResponseProcessor;
import com.cognos.xqe.ma4j.framework.MAGlobalsProcessor;
import com.cognos.xqe.ma4j.framework.MAIDManager;
import com.cognos.xqe.ma4j.framework.MAObjectBrowser;
import com.cognos.xqe.ma4j.framework.MAPropertyParser;
import com.cognos.xqe.ma4j.framework.MAQueryParser;
import com.cognos.xqe.ma4j.framework.MAQueryProcessor;
import com.cognos.xqe.ma4j.framework.MAResolverFullPath;
import com.cognos.xqe.ma4j.framework.MAResolverRefPath;
import com.cognos.xqe.ma4j.framework.MAScopeRelationships;
import com.cognos.xqe.ma4j.framework.MAShortcutProcessor;
import com.cognos.xqe.ma4j.framework.MAWorkingLocales;
import com.cognos.xqe.ma4j.utilities.MADOMResponseBuilder;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.ma.MAObjectNotExistException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IParameterMaps;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class MAQueryExecutor
extends MAObjectBrowser {
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private String promptFilterItemRef = "promptFilterItemRef";
    private String trueValue = "true";
    private static String replacement = null;
    private ParameterAccessCoordinator mPAC = null;
    private MAPropertyParser mPropertyParser = new MAPropertyParser();
    private MAQueryParser mQueryParser = null;
    private MAShortcutProcessor mMAShortcutProcessor = null;
    private MAIDManager mIdManager = null;
    private MADOMResponseBuilder mIdDOMResponseBuilder = null;
    private MAConstraintProcessor mConstraintProcessor = null;
    private MFWGateway mPGW = null;
    private short mLastRefType = (short)-1;
    private short mLastOrigRefType = (short)-1;
    private String mRefID = null;
    private String mPathID = null;
    private MFWNodeHandle mLastHandle = null;
    private String mStartAtRef = null;
    private String mStartAtPath = null;
    private String mRootCollectionName = null;
    private static final String FALSE = "false";

    public MAQueryExecutor(MFWGateway pGW, MAQueryParser queryParser, ParameterAccessCoordinator parameterAccessCoordinator) {
        super(pGW, queryParser.getWorkingLocales());
        this.mPGW = pGW;
        this.mQueryParser = queryParser;
        this.mPAC = parameterAccessCoordinator;
        this.mMAShortcutProcessor = new MAShortcutProcessor(pGW);
        this.mIdManager = new MAIDManager(pGW, queryParser.getWorkingLocales());
        this.mIdDOMResponseBuilder = new MADOMResponseBuilder();
        this.mConstraintProcessor = new MAConstraintProcessor(this.mPGW);
    }

    public MAQueryExecutor(MFWGateway pGW, MAQueryParser queryParser, MAConstraintProcessor constraintProcessor, ParameterAccessCoordinator parameterAccessCoordinator) {
        super(pGW, queryParser.getWorkingLocales());
        this.mPGW = pGW;
        this.mQueryParser = queryParser;
        this.mPAC = parameterAccessCoordinator;
        this.mMAShortcutProcessor = new MAShortcutProcessor(pGW);
        this.mIdManager = new MAIDManager(pGW, queryParser.getWorkingLocales());
        this.mIdDOMResponseBuilder = new MADOMResponseBuilder();
        this.mConstraintProcessor = constraintProcessor == null ? new MAConstraintProcessor(this.mPGW) : constraintProcessor;
    }

    public boolean executeQuery() {
        if (this.mQueryParser == null) {
            return false;
        }
        MAQueryExecutor.setupAttributeTransformer(this.mIdDOMResponseBuilder);
        ArrayList<String> properties = this.mQueryParser.getProperties();
        int depth = this.mQueryParser.getDepth();
        Set<Object> startPathCollection = new HashSet();
        startPathCollection = this.mQueryParser.getStartAtPathCollection();
        Object var4_4 = null;
        String startAtRef = null;
        this.mIdDOMResponseBuilder.buildResponseDOM();
        this.mIdDOMResponseBuilder.buildResponseHeader();
        Element responseRoot = this.mIdDOMResponseBuilder.getResponseRoot();
        if (startPathCollection.size() == 0) {
            String string = this.mQueryParser.getStartAtPath();
            startAtRef = this.mQueryParser.getStartAtRef();
            return this.executeQuery(properties, depth, string, startAtRef, responseRoot);
        }
        LinkedList<Element> responseColl = new LinkedList<Element>();
        for (String string : startPathCollection) {
            this.mIdDOMResponseBuilder.buildResponseDOM();
            this.mIdDOMResponseBuilder.buildResponseHeader();
            Element tempResponse = this.mIdDOMResponseBuilder.getResponseRoot();
            if (!this.executeQuery(properties, depth, string, startAtRef, tempResponse)) continue;
            responseColl.add(tempResponse);
        }
        if (this.buildResponseFromMultipleResponses(responseColl, responseRoot)) {
            this.mIdDOMResponseBuilder.setResponseRoot(responseRoot);
            return true;
        }
        return false;
    }

    private static void setupAttributeTransformer(MADOMResponseBuilder responseBuilder) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null != execEnv) {
            RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
            responseBuilder.setAttributeTransformer(reqEnv.getMAResponseAttributeTransformer());
        }
    }

    private boolean buildResponseFromMultipleResponses(LinkedList<Element> responseColl, Element responseRoot) {
        List children;
        if (responseColl.size() == 0) {
            return false;
        }
        HashMap<String, Node> responseStartPathNodeMap = new HashMap<String, Node>();
        Element firstResponse = responseColl.getFirst();
        Node root = null;
        Node packageNode = null;
        if (firstResponse != null) {
            List children2 = firstResponse.elements();
            root = (Node)children2.get(0);
            packageNode = (Node)children2.get(children2.size() - 1);
        }
        for (Element response : responseColl) {
            this.responseTreeWalker((Node)response, responseStartPathNodeMap);
        }
        Element responseChild = responseRoot;
        Node importedNode = null;
        if (root != null) {
            children = responseRoot.elements();
            responseChild = children.size() == 0 ? responseRoot : (Element)children.get(children.size() - 1);
            importedNode = (Node)root.clone();
            responseChild.add(importedNode);
        }
        children = responseChild.elements();
        MAStackTargetDestinationPair stackTdPair = new MAStackTargetDestinationPair((Node)children.get(children.size() - 1), root);
        Stack<MAStackTargetDestinationPair> stack = new Stack<MAStackTargetDestinationPair>();
        stack.push(stackTdPair);
        while (stack.size() > 0) {
            MAStackTargetDestinationPair stackPair = (MAStackTargetDestinationPair)stack.peek();
            stack.pop();
            Element targetNode = (Element)stackPair.targetNode;
            Element destNode = (Element)stackPair.destinationNode;
            String destNodePath = destNode.attributeValue("_path");
            Set<String> childrenPathCol = this.getChildrenPathFromMap(destNodePath, responseStartPathNodeMap);
            for (String childDestNodePath : childrenPathCol) {
                Node childDestNode = (Node)responseStartPathNodeMap.get(childDestNodePath);
                if (childDestNode == null) continue;
                Node childTargetNode = (Node)childDestNode.clone();
                targetNode.add(childTargetNode);
                stack.push(new MAStackTargetDestinationPair(childTargetNode, childDestNode));
            }
        }
        if (packageNode != null) {
            children = responseRoot.elements();
            responseChild = children.size() == 0 ? responseRoot : (Element)children.get(children.size() - 1);
            importedNode = (Node)packageNode.clone();
            responseChild.add(importedNode);
        }
        return true;
    }

    public Set<String> getChildrenPathFromMap(String parentStartPath, Map<String, Node> responseStartPathNodeMap) {
        HashSet<String> childrenPathSet = new HashSet<String>();
        MAIDManager mIdManager2 = new MAIDManager(this.mPGW, this.mQueryParser.getWorkingLocales());
        ArrayList<String> namePartsFromParentStartPath = mIdManager2.splitID(parentStartPath);
        if (namePartsFromParentStartPath.size() > 0) {
            for (Map.Entry<String, Node> pairs : responseStartPathNodeMap.entrySet()) {
                Node node;
                int parentParts;
                int childParts;
                String childPath = pairs.getKey();
                ArrayList<String> namePartsFromChildStartPath = mIdManager2.splitID(childPath);
                if (namePartsFromChildStartPath.size() <= 0 || (childParts = namePartsFromChildStartPath.size()) != (parentParts = namePartsFromParentStartPath.size()) + 1 || childPath.indexOf(parentStartPath) != 0 || (node = pairs.getValue()) == null) continue;
                childrenPathSet.add(childPath);
            }
        }
        return childrenPathSet;
    }

    public void responseTreeWalker(Node node, Map<String, Node> pathNodeMap) {
        String startPathProp = null;
        List children = ((Element)node).elements();
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            if (child.getNodeType() != 1) continue;
            startPathProp = ((Element)node).attributeValue("_path");
            if (!startPathProp.equals("")) {
                pathNodeMap.put(startPathProp, node);
            }
            if (child.elements().isEmpty()) continue;
            Node firstNode = (Node)child.elements().get(0);
            this.responseTreeWalker(firstNode, pathNodeMap);
        }
    }

    public boolean executeQuery(ArrayList<String> properties, int depth, String startAtPath, String startAtRef, Element response) {
        boolean result = false;
        MFWNodeHandle startingHandle = null;
        this.mRefID = null;
        this.mPathID = null;
        this.mLastRefType = (short)-1;
        this.mLastOrigRefType = (short)-1;
        Element originalResponseRoot = response;
        if (this.mQueryParser.getQueryInfo().isFunction()) {
            this.mPropertyParser.initialize();
            this.mPropertyParser.parseProperties(properties, "", this.mQueryParser, false);
            MAFunctionResponseProcessor funcProcessor = new MAFunctionResponseProcessor(this.mPGW, this.getProjectNode(), this.mConstraintProcessor, this.mQueryParser, this.mIdDOMResponseBuilder);
            funcProcessor.getFunctionResponse(originalResponseRoot);
        } else {
            String queryPath;
            MFWQuerySpec aQuerySpec;
            MFWNodeHandle[] handles;
            String dataSource;
            MFWNodeHandle measure;
            String isGenerateV5 = this.mQueryParser.getValueForAttribute("GenerateV5");
            String hasPths = this.mQueryParser.getValueForAttribute("hasMultipleStartPaths");
            if (startAtPath == null && startAtRef == null && (isGenerateV5 == null || isGenerateV5.compareTo(FALSE) < 0) && hasPths.compareTo(FALSE) == 0) {
                startAtPath = "";
            }
            MAObjectBrowser resolver = null;
            if (startAtPath != null && startAtRef == null) {
                resolver = new MAResolverFullPath(this.mPGW, this.mQueryParser.getWorkingLocales());
                startingHandle = resolver.resolvePath(startAtPath, null);
                this.mStartAtRef = resolver.getRefID();
                this.mStartAtPath = startAtPath;
                if (startingHandle == null) {
                    MAObjectNotExistException ex = new MAObjectNotExistException(XQEMessageKeys.MA_InvalidQueryStartingPoint);
                    ex.setLogLevel(LogLevel.INFO);
                    throw ex;
                }
            } else if (startAtPath == null && startAtRef != null) {
                if (!this.mIdManager.hasValidIDFormat(startAtRef)) {
                    MAObjectNotExistException ex = new MAObjectNotExistException(XQEMessageKeys.MA_InvalidQueryStartingPoint);
                    ex.setLogLevel(LogLevel.INFO);
                    throw ex;
                }
                resolver = new MAResolverRefPath(this.mPGW, this.mQueryParser.getWorkingLocales());
                this.mStartAtRef = startAtRef;
                this.mStartAtPath = resolver.getPathID();
                startingHandle = resolver.resolvePath(startAtRef, null);
                if (startingHandle == null) {
                    return false;
                }
            } else {
                return true;
            }
            boolean startFromShortcut = resolver.getStartContainsShortcut();
            MFWNodeHandle targetObject = null;
            if (this.mMAShortcutProcessor.isShortcut(startingHandle) && (targetObject = this.mMAShortcutProcessor.processShortcuts(startingHandle)) != null) {
                startFromShortcut = true;
            }
            MFWNodeHandle effectiveHandle = startingHandle;
            if (targetObject != null) {
                effectiveHandle = targetObject;
            }
            this.mRootCollectionName = null;
            this.mRootCollectionName = targetObject != null ? targetObject.getInfo().getName() : startingHandle.getInfo().getName();
            this.mPropertyParser.initialize();
            this.mPropertyParser.parseProperties(properties, this.mRootCollectionName, this.mQueryParser, true);
            MACollectionElement root = this.mPropertyParser.getCollectionsTree();
            effectiveHandle = startingHandle;
            if (targetObject != null) {
                effectiveHandle = targetObject;
            }
            if ((measure = effectiveHandle).getInfo().getRID() == MFWModelRes.getInstance().RID_measure && this.mPropertyParser.findVirtualProperty("_scopeLevels")) {
                this.processScopeRelationships(measure, resolver.getRefID(), response);
                this.processPackageProperties(originalResponseRoot);
                return true;
            }
            if (startingHandle != null) {
                Element interimElement = response;
                if (startAtRef == null) {
                    interimElement = this.processAncestorsSiblingsParentProperties(startingHandle, response);
                }
                this.mLastRefType = targetObject != null ? targetObject.getInfo().getRID() : startingHandle.getInfo().getRID();
                this.mLastOrigRefType = startingHandle.getInfo().getRID();
                this.mRefID = resolver.getRefID();
                this.mPathID = resolver.getPathID();
                this.mLastHandle = startingHandle;
                this.setupForBrowsing();
                Element elem = this.processProperties(startingHandle, targetObject, interimElement);
                effectiveHandle = startingHandle;
                if (targetObject != null) {
                    effectiveHandle = targetObject;
                }
                this.browseCollectionsTree(effectiveHandle, root, depth, startFromShortcut, elem);
                result = true;
            }
            if (this.mPropertyParser.findCollection(dataSource = "dataSource") && (handles = this.mPGW.query(aQuerySpec = MFWQuerySpec.create((String)(queryPath = new String("//dataSource"))))).length > 0) {
                for (int k = 0; k < handles.length; ++k) {
                    MFWNodeHandle handle = handles[k];
                    this.mIdManager.clearPathID();
                    this.mIdManager.clearRefID();
                    Element dsElem = this.processProperties(handle, null, originalResponseRoot);
                    MAQueryProcessor queryProcessor = new MAQueryProcessor();
                    queryProcessor.setCollections(this.mPropertyParser.getRequestedCollection());
                    queryProcessor.buildAncestryTree(dataSource);
                    MACollectionElement maCollElem = queryProcessor.getCollectionsTree();
                    this.browseCollectionsTree(handles[k], maCollElem, depth, false, dsElem);
                }
            }
            this.processMaps(originalResponseRoot);
        }
        if (this.mPGW != null) {
            if (!this.isModelXML()) {
                this.processPackageProperties(originalResponseRoot);
            } else {
                this.addPackagePropertiesModelXML(originalResponseRoot);
            }
        }
        Locale runLocale = LocaleConverter.strToLocale(this.mQueryParser.getRunLocale());
        Locale authLocale = LocaleConverter.strToLocale(this.mQueryParser.getAuthoringLocale());
        this.processGlobals(this.mPropertyParser.getSpecialProperties(), runLocale, authLocale, originalResponseRoot);
        return result;
    }

    private void addPackagePropertiesModelXML(Element response) {
        Element elem = this.mIdDOMResponseBuilder.createElement((Branch)response, "package");
        MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)"/project");
        MFWNodeHandle[] handles = this.mPGW.query(aQuerySpec);
        MFWNodeHandle projHandle = handles[0];
        String name = this.mPGW.getObjectPropertyValue(projHandle, MFWModelRes.getInstance().RID_name);
        elem.addAttribute("name", name);
    }

    public boolean isModelXML() {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (execEnv != null && execEnv.getRequestEnvironment() != null) {
            String mp = null;
            mp = ((RequestEnvironment)execEnv.getRequestEnvironment()).getModelPath();
            return mp != null && mp.endsWith("model.xml");
        }
        return false;
    }

    private void processMaps(Element responseRootElement) {
        RequestEnvironment reqEnv;
        IParameterMaps cookies;
        boolean doParameterMap = this.mPropertyParser.findCollection("parameterMap");
        boolean doParameterMapEntry = this.mPropertyParser.findCollection("parameterMapEntry");
        boolean doQueryItemMap = this.mPropertyParser.findCollection("queryItemMap");
        boolean doQueryItemMapEntry = this.mPropertyParser.findCollection("queryItemMapEntry");
        if (!(doParameterMap || doParameterMapEntry || doQueryItemMap || doQueryItemMapEntry)) {
            return;
        }
        ArrayList<String> requestedParameterMapNames = new ArrayList<String>();
        MAConstraint constraint = null;
        if (this.mConstraintProcessor.hasConstraints()) {
            constraint = this.mConstraintProcessor.getConstraint();
            List<MAConstraint> children = constraint.getChildren();
            for (MAConstraint child : children) {
                String firstParameter = child.getFirstParameter();
                if (!firstParameter.equals("name") || child.getOperation() != MAConstraint.OperationType.OPERATION_EQUAL) continue;
                String secondParameter = child.getSecondParameter();
                requestedParameterMapNames.add(secondParameter);
            }
        }
        if (requestedParameterMapNames.size() == 0) {
            String queryPath = new String("//parameterMap");
            MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)queryPath);
            MFWNodeHandle[] handles = this.mPGW.query(aQuerySpec);
            for (MFWNodeHandle handle : handles) {
                String paramaterMapName = this.getName(handle, MAWorkingLocales.getRunLocale());
                if (paramaterMapName.equals("_governor")) continue;
                requestedParameterMapNames.add(paramaterMapName);
            }
        }
        if (requestedParameterMapNames.size() == 0) {
            return;
        }
        this.processParameterMaps(responseRootElement, requestedParameterMapNames);
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null != execEnv && (cookies = (reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment()).getOrCreateCookieMap()) != null) {
            Map<String, String> mapContent = cookies.getAllEntries("cookies");
            this.processCookiesParameterMap(responseRootElement, mapContent);
        }
    }

    private void processParameterMaps(Element rootElement, List<String> requestedParameterMaps) {
        ArrayList<IParameterMaps> allMaps = this.mPAC.getAllMaps();
        block0: for (String parameterMapName : requestedParameterMaps) {
            if (parameterMapName.equals("_env")) {
                this.processEnvParameterMap(rootElement);
                continue;
            }
            boolean foundMap = false;
            for (IParameterMaps map : allMaps) {
                if (map.isModelMap()) {
                    for (String mapName : map.getMapNames()) {
                        if (!mapName.equals(parameterMapName)) continue;
                        this.processParameterMap(rootElement, mapName, map);
                        foundMap = true;
                        break;
                    }
                }
                if (map.isQueryItemMap()) {
                    for (String mapName : map.getMapNames()) {
                        if (!mapName.equals(parameterMapName)) continue;
                        this.processQueryItemMap(rootElement, mapName, map);
                        foundMap = true;
                        break;
                    }
                }
                if (!foundMap) continue;
                continue block0;
            }
        }
    }

    private void processCookiesParameterMap(Element parent, Map<String, String> mapContent) {
        Element dynamic = this.mIdDOMResponseBuilder.createElement((Branch)parent, "dynamic");
        Element parameterMapElement = this.mIdDOMResponseBuilder.createElement((Branch)dynamic, "parameterMap");
        this.mIdDOMResponseBuilder.addAttribute(parameterMapElement, "name", "cookies");
        Set<String> parameterMapEntryProperties = this.mPropertyParser.getRestrictedProperties("parameterMapEntry");
        if (parameterMapEntryProperties != null) {
            TreeSet<String> keySet = new TreeSet<String>(mapContent.keySet());
            for (String key : keySet) {
                String value = mapContent.get(key);
                this.processParameterMapEntry(parameterMapElement, key, value, parameterMapEntryProperties);
            }
        }
    }

    private void processEnvParameterMap(Element parent) {
        Element dynamic = this.mIdDOMResponseBuilder.createElement((Branch)parent, "dynamic");
        Element parameterMapElement = this.mIdDOMResponseBuilder.createElement((Branch)dynamic, "parameterMap");
        HashMap<String, String> propertyValues = new HashMap<String, String>();
        Set<String> requestedProperties = this.mPropertyParser.getRestrictedProperties("parameterMap");
        if (requestedProperties != null) {
            for (String property : requestedProperties) {
                MFWNodeHandle handle;
                String hiddenProperty;
                if (property.equals("name")) {
                    propertyValues.put(property, "_env");
                }
                if (!property.equals("hidden")) continue;
                String hidden = "0";
                String query = "//parameterMap[name='_env']";
                MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)query);
                MFWNodeHandle[] handles = this.mPGW.query(aQuerySpec);
                if (handles != null && handles.length == 1 && (hiddenProperty = this.mPGW.getObjectPropertyValue(handle = handles[0], MFWModelRes.getInstance().RID_hidden)) != null && hiddenProperty.equals(this.trueValue)) {
                    hidden = "1";
                }
                propertyValues.put(property, hidden);
            }
        }
        this.addAttributes(parameterMapElement, propertyValues);
        this.mIdDOMResponseBuilder.addAttribute(parameterMapElement, "name", "_env");
        this.processParameterMapEntry(parameterMapElement, "_env");
    }

    private void processParameterMap(Element parent, String mapName, IParameterMaps parameterMapsModel) {
        Element parameterMapElement = this.mIdDOMResponseBuilder.createElement((Branch)parent, "parameterMap");
        this.processParameterMapProperties(parameterMapElement, mapName, parameterMapsModel);
        this.processParameterMapEntry(parameterMapElement, mapName);
    }

    private void processParameterMapProperties(Element parameterElement, String name, IParameterMaps mapsFromModel) {
        Map<String, String> propertyValues = this.getParameterMapPropertyValues(name, mapsFromModel);
        this.addAttributes(parameterElement, propertyValues);
        this.mIdDOMResponseBuilder.addAttribute(parameterElement, "name", name);
    }

    private void addAttributes(Element element, Map<String, String> attributes) {
        if (attributes != null && attributes.size() > 0) {
            TreeSet<String> sortedSet = new TreeSet<String>(attributes.keySet());
            for (String key : sortedSet) {
                String value = attributes.get(key);
                this.mIdDOMResponseBuilder.addAttribute(element, key, value);
            }
        }
    }

    private Map<String, String> getParameterMapPropertyValues(String mapName, IParameterMaps maps) {
        HashMap<String, String> result = new HashMap<String, String>();
        Set<String> requestedProperties = this.mPropertyParser.getRestrictedProperties("parameterMap");
        if (requestedProperties != null) {
            for (String property : requestedProperties) {
                String defaultValue;
                if (property.equals("name")) {
                    String nameValue = mapName;
                    result.put(property, nameValue);
                }
                if (property.equals("hidden")) {
                    String hiddenValue = this.getHiddenPropertyValue(mapName, maps);
                    result.put(property, hiddenValue);
                }
                if (!property.equals("defaultValue") || (defaultValue = this.getDefaultPropertyValue(mapName, maps)) == null) continue;
                result.put(property, defaultValue);
            }
        }
        return result;
    }

    private String getHiddenPropertyValue(String mapName, IParameterMaps maps) {
        boolean hiddenProperty = false;
        if (maps.isModelMap() || maps.isQueryItemMap()) {
            hiddenProperty = maps.getHiddenProperty(mapName);
        }
        String result = null;
        result = hiddenProperty ? "1" : "0";
        return result;
    }

    private String getDefaultPropertyValue(String mapName, IParameterMaps maps) {
        String result = null;
        if (maps.isModelMap() || maps.isQueryItemMap()) {
            result = maps.getDefault(mapName);
        }
        return result;
    }

    private void processParameterMapEntry(Element parentElement, String mapName) {
        if (!this.mPropertyParser.findCollection("parameterMapEntry")) {
            return;
        }
        Set<String> parameterMapEntryProperties = this.mPropertyParser.getRestrictedProperties("parameterMapEntry");
        Map<String, String> entries = this.mPAC.getAllEntries(mapName);
        TreeSet<String> keySet = new TreeSet<String>(entries.keySet());
        for (String key : keySet) {
            String value = entries.get(key);
            this.processParameterMapEntry(parentElement, key, value, parameterMapEntryProperties);
        }
    }

    private void processParameterMapEntry(Element parent, String key, String value, Set<String> properties) {
        Element entry = this.mIdDOMResponseBuilder.createElement((Branch)parent, "parameterMapEntry");
        this.addKeyValueAttributes(entry, key, value, properties);
    }

    private void processQueryItemMap(Element parent, String mapName, IParameterMaps parameterMapsQI) {
        Element queryItemMap = this.mIdDOMResponseBuilder.createElement((Branch)parent, "parameterMap");
        this.processParameterMapProperties(queryItemMap, mapName, parameterMapsQI);
        if (this.mPropertyParser.findCollection("queryItemMap")) {
            this.mIdDOMResponseBuilder.createElement((Branch)queryItemMap, "queryItemMap");
        } else if (this.mPropertyParser.findCollection("queryItemMapEntry")) {
            Set<String> queryItemMapEntryProperties = this.mPropertyParser.getRestrictedProperties("queryItemMapEntry");
            Map<String, String> entries = parameterMapsQI.getAllEntries(mapName);
            TreeSet<String> keys = new TreeSet<String>(entries.keySet());
            for (String key : keys) {
                String value = entries.get(key);
                this.processQueryItemMapEntry(queryItemMap, key, value, queryItemMapEntryProperties);
            }
        }
    }

    private void processQueryItemMapEntry(Element parent, String key, String value, Set<String> properties) {
        Element entry = this.mIdDOMResponseBuilder.createElement((Branch)parent, "queryItemMapEntry");
        this.addKeyValueAttributes(entry, key, value, properties);
    }

    private void addKeyValueAttributes(Element element, String key, String value, Set<String> properties) {
        if (properties.contains("key")) {
            this.mIdDOMResponseBuilder.addAttribute(element, "key", key);
        }
        if (properties.contains("value")) {
            this.mIdDOMResponseBuilder.addAttribute(element, "value", value);
        }
    }

    private void browseModel(MFWNodeHandle parentHandle, ArrayList<MACollectionElement> children, int depth, boolean inShortcut, Element parentElement) {
        if (depth == 0) {
            return;
        }
        if (parentHandle.getNameRID() == MFWModelRes.getInstance().RID_namespace && this.mPGW.getObjectBooleanPropertyValue(parentHandle, MFWModelRes.getInstance().RID_isCube) && !this.isObjectIncluded(parentHandle, false) && !inShortcut) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("/*[local-name()='");
        int size = children.size();
        if (size == 0) {
            return;
        }
        for (int k = 0; k < size; ++k) {
            MACollectionElement child = children.get(k);
            String childType = child.getName();
            buffer.append(childType);
            if (childType.equals("folder")) {
                childType = "namespace";
                buffer.append("' or local-name()='");
                buffer.append(childType);
            }
            if (k == size - 1) {
                buffer.append("']");
                break;
            }
            buffer.append("' or local-name()='");
        }
        String queryPath = buffer.toString();
        this.queryObject(parentHandle, children, depth, queryPath, inShortcut, parentElement);
    }

    private void queryObject(MFWNodeHandle parentHandle, ArrayList<MACollectionElement> children, int depth, String queryPath, boolean inShortcut, Element parentElement) {
        MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)queryPath);
        aQuerySpec.setRetrievalDepth(1);
        MFWNodeHandle[] handles = null;
        handles = parentHandle != null ? this.mPGW.queryObject(parentHandle, aQuerySpec) : this.mPGW.query(aQuerySpec);
        for (int k = 0; k < handles.length; ++k) {
            String lastPathID;
            String lastRefID;
            MFWNodeHandle lastHandle;
            short lastOrigRefType;
            short lastRefType;
            block12: {
                String namePropRef;
                String nameProp;
                short type;
                String name;
                MFWNodeHandle handle;
                block13: {
                    lastRefType = this.mIdManager.getLastRefType();
                    lastOrigRefType = this.mIdManager.getLastOrigRefType();
                    lastHandle = this.mIdManager.getLastHandle();
                    lastRefID = this.mIdManager.getRefID();
                    lastPathID = this.mIdManager.getPathID();
                    handle = handles[k];
                    if (handle == null) break block12;
                    MFWInfo info = handle.getInfo();
                    name = info.getName();
                    type = info.getRID();
                    nameProp = this.getName(handle, MAWorkingLocales.getRunLocale(), MAQueryExecutor.MODEL_RES.RID_hierarchy == type);
                    namePropRef = this.getName(handle, MAWorkingLocales.getRefLocale(this.getUseDesignLocaleForReferenceID()));
                    if (!this.mMAShortcutProcessor.isShortcut(handle)) break block13;
                    MFWNodeHandle targetObject = this.mMAShortcutProcessor.processShortcuts(handle);
                    if (targetObject == null) break block12;
                    info = targetObject.getInfo();
                    name = info.getName();
                    if (this.isHidden(handle) || !this.isObjectIncluded(handle, inShortcut)) {
                        this.mIdManager.initializeRefID(lastRefID, lastOrigRefType, lastRefType, lastHandle);
                        this.mIdManager.initializePathID(lastPathID);
                        continue;
                    }
                    this.mIdManager.buildRefID(namePropRef, type, info.getRID(), targetObject);
                    this.mIdManager.buildPathID(nameProp);
                    ArrayList<String> xpath = this.mIdManager.buildSchemaXPathToRoot(targetObject);
                    MACollectionElement targetCollectionElement = this.findCollectionElementFromCollectionTree(xpath);
                    if (targetCollectionElement == null) break block12;
                    Element effectiveElement = null;
                    if (this.mQueryParser.hasConstraints()) {
                        effectiveElement = parentElement;
                    } else {
                        MFWNodeHandle effectiveHandle = targetObject;
                        if (targetObject != null) {
                            effectiveHandle = handle;
                        }
                        effectiveElement = this.constraintsFilter(effectiveHandle) ? this.processProperties(handle, targetObject, parentElement) : parentElement;
                    }
                    this.browseCollectionsTree(targetObject, targetCollectionElement, depth - 1, true, effectiveElement);
                    break block12;
                }
                Element effectiveElement = parentElement;
                boolean hidden = false;
                if (this.isHidden(handle) || !this.isObjectIncluded(handle, inShortcut)) {
                    this.mIdManager.buildRefID(namePropRef, type, type, handle);
                    this.mIdManager.buildPathID(nameProp);
                    hidden = true;
                } else {
                    MFWNodeHandle[] roleHandles;
                    Set<String> props = this.mPropertyParser.getVirtualProperties();
                    Iterator<String> prit = props.iterator();
                    boolean isIntrinsicPropertiesOff = false;
                    while (prit.hasNext()) {
                        String pname = prit.next();
                        if (!pname.equals("_IntrinsicPropertiesOff")) continue;
                        isIntrinsicPropertiesOff = true;
                    }
                    if (isIntrinsicPropertiesOff && name.equals("queryItem") && (roleHandles = this.hasRoles(handle)).length != 0 && this.hasCustomRoles(roleHandles)) continue;
                    this.mIdManager.buildRefID(namePropRef, type, type, handle);
                    this.mIdManager.buildPathID(this.getName(handle, MAWorkingLocales.getRunLocale()));
                    Element elem = null;
                    if (this.constraintsFilter(handle)) {
                        elem = this.processProperties(handle, null, parentElement);
                    }
                    if ((effectiveElement = elem) == null || this.mQueryParser.hasConstraints()) {
                        effectiveElement = parentElement;
                    }
                }
                int size = children.size();
                for (int i = 0; i < size; ++i) {
                    boolean folder;
                    MACollectionElement child = children.get(i);
                    String childType = child.getName();
                    boolean namespace = name.equals("namespace") && childType.equals("folder");
                    boolean bl = folder = name.equals("folder") && childType.equals("folder");
                    if ((folder || namespace) && hidden) {
                        this.browseCollectionsTree(handle, child, depth, inShortcut, effectiveElement);
                        continue;
                    }
                    if (!folder && !namespace && !name.equals(childType)) continue;
                    this.browseCollectionsTree(handle, child, depth - 1, inShortcut, effectiveElement);
                }
            }
            this.mIdManager.initializeRefID(lastRefID, lastOrigRefType, lastRefType, lastHandle);
            this.mIdManager.initializePathID(lastPathID);
        }
    }

    private boolean isHidden(MFWNodeHandle handle) {
        boolean hasHiddenProperty = handle.getInfo().findChildInfo(MFWModelRes.getInstance().RID_hidden) != null;
        boolean isHidden = false;
        if (hasHiddenProperty) {
            isHidden = this.mPGW.getObjectBooleanPropertyValue(handle, MFWModelRes.getInstance().RID_hidden);
        }
        return isHidden;
    }

    private boolean isObjectIncluded(MFWNodeHandle handle, boolean inShortcut) {
        boolean hasVisibleProperty = handle.getInfo().findChildInfo(MFWModelRes.getInstance().RID_visible) != null;
        String visibility = null;
        if (!hasVisibleProperty) {
            return true;
        }
        try {
            visibility = this.mPGW.getObjectPropertyValue(handle, MFWModelRes.getInstance().RID_visible);
        }
        catch (MFWException e) {
            mErrorLogger.log(e);
            return true;
        }
        if (visibility != null) {
            if (inShortcut) {
                return visibility.equals("visibleAndAccessible") || visibility.equals("hiddenAndAccessible");
            }
            return visibility.equals("visibleAndAccessible");
        }
        return true;
    }

    private void browseCollectionsTree(MFWNodeHandle parentHandle, MACollectionElement parentCollectionElement, int depth, boolean inShortcut, Element parentElement) {
        boolean self = parentCollectionElement.getSelf();
        ArrayList<MACollectionElement> children = parentCollectionElement.getChildren();
        if (self && !parentCollectionElement.findChild(parentCollectionElement)) {
            children.add(parentCollectionElement);
        }
        this.browseModel(parentHandle, children, depth, inShortcut, parentElement);
    }

    private Element processProperties(MFWNodeHandle handle, MFWNodeHandle shortcutTarget, Element parentElement) {
        MFWInfo info = handle.getInfo();
        String name = info.getName();
        if (shortcutTarget != null) {
            info = shortcutTarget.getInfo();
            name = info.getName();
        }
        if (name.equals("namespace")) {
            name = "folder";
        }
        Element elem = this.mIdDOMResponseBuilder.createElement((Branch)parentElement, name);
        boolean bEnumLables = true;
        String enumLables = this.mQueryParser.getValueForAttribute("_enumLabels");
        if (enumLables != null) {
            Integer enumLab = Integer.valueOf(enumLables);
            if (enumLab == 0) {
                bEnumLables = false;
            } else if (enumLab == 1) {
                bEnumLables = true;
            }
        } else {
            bEnumLables = false;
        }
        ArrayList<String> properties = this.getProperties(handle, shortcutTarget, this.mPropertyParser.getProperties(), this.mPropertyParser.getShortcutProperties(), bEnumLables, MAWorkingLocales.getRunLocale());
        Set<String> props = this.mPropertyParser.getProperties();
        Iterator<String> prit = props.iterator();
        int index = 0;
        int size = properties.size();
        while (prit.hasNext()) {
            String value;
            String pname = prit.next();
            if (index >= size || (value = properties.get(index++)) == null) continue;
            this.mIdDOMResponseBuilder.addAttribute(elem, pname, value);
        }
        this.addPromptInfo(handle, bEnumLables, elem);
        if (this.mPropertyParser.findProperty(name, "isNamespace")) {
            if (handle.getInfo().getRID() == MFWModelRes.getInstance().RID_namespace) {
                this.mIdDOMResponseBuilder.addAttribute(elem, "isNamespace", "1");
            } else if (handle.getInfo().getRID() == MFWModelRes.getInstance().RID_folder) {
                this.mIdDOMResponseBuilder.addAttribute(elem, "isNamespace", "0");
            } else if (handle.getInfo().getRID() == MFWModelRes.getInstance().RID_shortcut && shortcutTarget != null && shortcutTarget.getInfo().getRID() == MFWModelRes.getInstance().RID_folder) {
                if (shortcutTarget.getInfo().getRID() == MFWModelRes.getInstance().RID_namespace) {
                    this.mIdDOMResponseBuilder.addAttribute(elem, "isNamespace", "1");
                } else if (shortcutTarget.getInfo().getRID() == MFWModelRes.getInstance().RID_folder) {
                    this.mIdDOMResponseBuilder.addAttribute(elem, "isNamespace", "0");
                }
            }
        }
        props = this.mPropertyParser.getVirtualProperties();
        for (String pname : props) {
            this.processVirtualProperty(name, pname, elem);
        }
        Set<String> restrictedPropertiesNames = this.mPropertyParser.getRestrictedProperties(name);
        if (restrictedPropertiesNames != null) {
            for (String propertyName : restrictedPropertiesNames) {
                if (this.processVirtualProperty(name, propertyName, elem)) continue;
                if (info.getRID() == MFWModelRes.getInstance().RID_property && propertyName.equals("value")) {
                    if (handle == null) continue;
                    boolean noValue = false;
                    MFWNodeHandle[] fHandles = null;
                    String queryPath = "__Value";
                    MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)queryPath);
                    try {
                        fHandles = this.mPGW.queryObject(handle, aQuerySpec);
                    }
                    catch (MFWException t) {
                        mErrorLogger.log(t);
                        noValue = true;
                    }
                    if (noValue) continue;
                    String value = "";
                    if (fHandles != null && fHandles.length > 0) {
                        value = this.getValue(fHandles[0], bEnumLables);
                    }
                    if (value == null) continue;
                    this.mIdDOMResponseBuilder.addAttribute(elem, propertyName, value);
                    continue;
                }
                MFWNodeHandle parentHandle = handle;
                String value = shortcutTarget != null ? this.getShortcutPropertyValues(handle, shortcutTarget, propertyName, bEnumLables, MAWorkingLocales.getRunLocale()) : this.getProperty(parentHandle, propertyName, bEnumLables, MAWorkingLocales.getRunLocale(), info.getRID() == MAQueryExecutor.MODEL_RES.RID_hierarchy);
                if (value == null) continue;
                if (propertyName.equals("dataSourceRef")) {
                    propertyName = "sources";
                } else if (propertyName.equals(this.promptFilterItemRef) && MAQueryExecutor.suppressPromptFilterItemRefRequired()) {
                    value = "";
                }
                this.mIdDOMResponseBuilder.addAttribute(elem, propertyName, value);
            }
        }
        return elem;
    }

    public static boolean suppressPromptFilterItemRefRequired() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return configuration.getBooleanProperty("ma4j.suppressPromptFilterItemRef[@enabled]", false);
    }

    public static String getInvalidXmlCharacterReplacement() {
        return replacement;
    }

    private String getShortcutPropertyValues(MFWNodeHandle objectHandle, MFWNodeHandle targetHandle, String propertyName, boolean bEnumLables, int workingLocaleType) {
        String value = null;
        if (propertyName.equals("name")) {
            value = this.getProperty(objectHandle, propertyName, bEnumLables, workingLocaleType);
        } else if (propertyName.equals("refobj")) {
            value = this.getProperty(objectHandle, propertyName, bEnumLables, workingLocaleType);
        } else if (propertyName.equals("_path")) {
            value = this.getProperty(objectHandle, propertyName, bEnumLables, workingLocaleType);
        } else if (propertyName.equals("screenTip")) {
            value = this.getProperty(objectHandle, propertyName, bEnumLables, workingLocaleType);
            if (value == null) {
                value = this.getProperty(targetHandle, propertyName, bEnumLables, workingLocaleType);
            }
        } else if (propertyName.equals("description")) {
            value = this.getProperty(objectHandle, propertyName, bEnumLables, workingLocaleType);
            if (value == null) {
                value = this.getProperty(targetHandle, propertyName, bEnumLables, workingLocaleType);
            }
        } else {
            value = this.getProperty(targetHandle, propertyName, bEnumLables, workingLocaleType);
        }
        return value;
    }

    private boolean processVirtualProperty(String parentName, String pname, Element elem) {
        boolean propPrecessed = false;
        String value = null;
        if (pname.equals("_ref")) {
            value = this.mIdManager.getRefID();
        } else if (pname.equals("_path")) {
            value = this.mIdManager.getPathID();
            value = MAQueryExecutor.encodeSquareBrackets(value);
        }
        if (pname.equals("_ref") || pname.equals("_path")) {
            this.mIdDOMResponseBuilder.addAttribute(elem, pname, value);
            propPrecessed = true;
        }
        return propPrecessed;
    }

    public MFWNodeHandle[] hasRoles(MFWNodeHandle handle) {
        String queryPath = new String("role");
        MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)queryPath);
        MFWNodeHandle[] roleHandles = this.mPGW.queryObject(handle, aQuerySpec);
        return roleHandles;
    }

    private boolean hasCustomRoles(MFWNodeHandle[] roleHandles) {
        boolean isCustomRole = true;
        if (roleHandles.length > 0) {
            for (int k = 0; k < roleHandles.length && isCustomRole; ++k) {
                MFWNodeHandle roleHandle = roleHandles[k];
                String roleName = this.getProperty(roleHandle, "name", this.mQueryParser.getEnumLabels(), MAWorkingLocales.getRunLocale());
                if (!MetadataUtil.isVisibleRole(roleName)) continue;
                isCustomRole = false;
            }
        }
        return isCustomRole;
    }

    public boolean hasMemberCaptionRole(MFWNodeHandle[] roleHandles) {
        boolean isCaptionRole = false;
        if (roleHandles.length > 0) {
            for (int k = 0; k < roleHandles.length && !isCaptionRole; ++k) {
                MFWNodeHandle roleHandle = roleHandles[k];
                String roleName = this.getProperty(roleHandle, "name", this.mQueryParser.getEnumLabels(), MAWorkingLocales.getRunLocale());
                if (!roleName.equals("_memberCaption")) continue;
                isCaptionRole = true;
            }
        }
        return isCaptionRole;
    }

    private void addPromptInfo(MFWNodeHandle handle, boolean enumLabels, Element elem) {
        boolean bQueryItem = false;
        MFWNodeHandle origHandle = null;
        if (handle.getInfo().getRID() == MFWModelRes.getInstance().RID_queryItem) {
            bQueryItem = true;
            origHandle = handle;
        }
        if (this.mPropertyParser.findVirtualProperty("_effectivePromptInfo") && (handle.getInfo().getRID() == MFWModelRes.getInstance().RID_level || bQueryItem)) {
            HashSet<String> promptProp = new HashSet<String>();
            promptProp.add("promptType");
            promptProp.add(this.promptFilterItemRef);
            promptProp.add("promptDisplayItemRef");
            promptProp.add("promptUseItemRef");
            promptProp.add("promptCascadeOnRef");
            String queryPath = new String("queryItem");
            if (bQueryItem) {
                handle = handle.getParent();
            }
            MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)queryPath);
            MFWNodeHandle[] handles = this.mPGW.queryObject(handle, aQuerySpec);
            HashMap<String, String> promptMap = new HashMap<String, String>();
            if (handles.length > 0) {
                MFWNodeHandle qiHandle;
                int k;
                if (bQueryItem) {
                    for (k = 0; k < handles.length; ++k) {
                        qiHandle = handles[k];
                        if (!qiHandle.equals((Object)origHandle)) continue;
                        for (String propName : promptProp) {
                            String value = this.getProperty(qiHandle, propName, enumLabels, MAWorkingLocales.getRunLocale());
                            promptMap.put(propName, value);
                        }
                    }
                } else {
                    for (k = 0; k < handles.length; ++k) {
                        qiHandle = handles[k];
                        MFWNodeHandle[] roleHandles = this.hasRoles(qiHandle);
                        if (roleHandles == null || !this.hasMemberCaptionRole(roleHandles)) continue;
                        for (String propName : promptProp) {
                            String value = this.getProperty(qiHandle, propName, enumLabels, MAWorkingLocales.getRunLocale());
                            promptMap.put(propName, value);
                        }
                    }
                }
            }
            Iterator it = promptProp.iterator();
            while (it.hasNext()) {
                String propValue = "";
                String promptName = (String)it.next();
                if (promptMap.containsKey(promptName)) {
                    propValue = (String)promptMap.get(promptName);
                }
                this.mIdDOMResponseBuilder.addAttribute(elem, promptName, propValue);
            }
        }
    }

    public String getResponseDOMXML() {
        return this.mIdDOMResponseBuilder.toString();
    }

    public Document getResponseDOM() {
        return this.mIdDOMResponseBuilder.getResponseDOM();
    }

    public String getStartAtRef() {
        return this.mStartAtRef;
    }

    public String getStartAtPath() {
        return this.mStartAtPath;
    }

    private void processScopeRelationships(MFWNodeHandle measure, String refID, Element response) {
        String measureTargetRefID = this.mIdManager.buildRefPath(measure);
        String measureName = this.getName(measure, MAWorkingLocales.getRunLocale());
        Element elemMeasure = this.mIdDOMResponseBuilder.createElement((Branch)response, "measure");
        this.mIdDOMResponseBuilder.addAttribute(elemMeasure, "_ref", MAQueryExecutor.encodeSquareBrackets(refID));
        this.mIdDOMResponseBuilder.addAttribute(elemMeasure, "name", measureName);
        MAScopeRelationships scopeRelationships = new MAScopeRelationships(this.mPGW, this.mQueryParser.getWorkingLocales());
        ArrayList<ArrayList<String>> levels = scopeRelationships.processScopeRelationship(measureTargetRefID, refID, measure);
        if (levels != null) {
            int size = levels.size();
            for (int k = 0; k < size; ++k) {
                ArrayList<String> levelIDs = levels.get(k);
                String levelName = levelIDs.get(0);
                for (int m = 1; m < levelIDs.size(); ++m) {
                    String levelRefID = levelIDs.get(m);
                    Element elemLevel = this.mIdDOMResponseBuilder.createElement((Branch)elemMeasure, "level");
                    this.mIdDOMResponseBuilder.addAttribute(elemLevel, "_ref", MAQueryExecutor.encodeSquareBrackets(levelRefID));
                    this.mIdDOMResponseBuilder.addAttribute(elemLevel, "name", levelName);
                }
            }
        }
    }

    private MACollectionElement findCollectionElementFromCollectionTree(ArrayList<String> xpath) {
        if (xpath != null) {
            MACollectionElement child = this.mPropertyParser.getCollectionsTree();
            int size = xpath.size();
            for (int k = size - 1; k >= 1; --k) {
                String name = xpath.get(k);
                if (!name.equals(child.getName()) || k - 1 < 0) continue;
                ArrayList<MACollectionElement> children = child.getChildren();
                if (child.getSelf() && !this.findInCollectionsArray(children, child)) {
                    children.add(child);
                }
                int chSize = children.size();
                boolean found = false;
                for (int m = 0; m < chSize; ++m) {
                    child = children.get(m);
                    if (!child.getName().equals(xpath.get(k - 1))) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return null;
            }
            return child;
        }
        return null;
    }

    private boolean findInCollectionsArray(ArrayList<MACollectionElement> collections, MACollectionElement child) {
        int size = collections.size();
        for (int k = 0; k < size; ++k) {
            MACollectionElement element = collections.get(k);
            if (!element.getName().equals(child.getName())) continue;
            return true;
        }
        return false;
    }

    private void setupForBrowsing() {
        this.mIdManager.initializeRefID(this.mRefID, this.mLastOrigRefType, this.mLastRefType, this.mLastHandle);
        this.mIdManager.initializePathID(this.mPathID);
    }

    private void processGlobals(Set<String> specialProperties, Locale runlocale, Locale expressionLocale, Element response) {
        int size = specialProperties.size();
        if (size == 0) {
            return;
        }
        MAGlobalsProcessor globProc = new MAGlobalsProcessor(this.mPGW, this.mQueryParser.getWorkingLocales());
        for (String pname : specialProperties) {
            Element elem;
            if (pname.compareTo("decimalSeparator") == 0) {
                elem = this.mIdDOMResponseBuilder.createElement((Branch)response, "decimalSeparator");
                String decimalSeparator2 = globProc.getDecimalSeparator(expressionLocale);
                this.mIdDOMResponseBuilder.addAttribute(elem, "value", decimalSeparator2);
            }
            if (pname.compareTo("listSeparator") == 0) {
                elem = this.mIdDOMResponseBuilder.createElement((Branch)response, "listSeparator");
                String listSeparator2 = globProc.getListSeparator(expressionLocale);
                this.mIdDOMResponseBuilder.addAttribute(elem, "value", listSeparator2);
            }
            if (pname.compareTo("defaultLocale") == 0) {
                elem = this.mIdDOMResponseBuilder.createElement((Branch)response, "defaultLocale");
                String defaultLocale = globProc.getDefaultLocale();
                this.mIdDOMResponseBuilder.createTextNode(elem, defaultLocale);
            }
            if (pname.compareTo("supportedLocales") == 0) {
                elem = this.mIdDOMResponseBuilder.createElement((Branch)response, "locales");
                Set<String> locales = globProc.getSupportedLocales();
                Iterator<String> localesIter = locales.iterator();
                while (localesIter.hasNext()) {
                    Element childElem = this.mIdDOMResponseBuilder.createElement((Branch)elem, "locales");
                    String supportedLocale = localesIter.next();
                    this.mIdDOMResponseBuilder.createTextNode(childElem, supportedLocale);
                }
            }
            if (pname.compareTo("effectiveLocale") == 0) {
                elem = this.mIdDOMResponseBuilder.createElement((Branch)response, "effectiveLocale");
                String effLocale = globProc.getEffectiveContentLocale(runlocale);
                this.mIdDOMResponseBuilder.createTextNode(elem, effLocale);
            }
            if (pname.compareTo("modelSearchPath") != 0) continue;
            elem = this.mIdDOMResponseBuilder.createElement((Branch)response, "modelSearchPath");
            String modelSearchPath = this.isModelXML() ? this.getModuleSearchPath() : this.mQueryParser.getModelSearchPath();
            this.mIdDOMResponseBuilder.addAttribute(elem, "value", modelSearchPath);
        }
    }

    private String getModuleSearchPath() {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (execEnv != null && execEnv.getRequestEnvironment() != null) {
            return ((RequestEnvironment)execEnv.getRequestEnvironment()).getModuleSearchPath();
        }
        return null;
    }

    private void processPackageProperties(Element response) {
        String propValue;
        Element elem = this.mIdDOMResponseBuilder.createElement((Branch)response, "package");
        Map<String, Set<String>> props = this.mPropertyParser.getRestrictedProperties();
        Set<String> propColl = props.get("package");
        ArrayList<String> requestedPackageProperties = new ArrayList<String>();
        ArrayList<String> requestedPackageSpecialProperties = new ArrayList<String>();
        if (propColl == null) {
            requestedPackageProperties.add("defaultName");
        } else {
            if (!propColl.contains("name")) {
                propColl.add("name");
            }
            for (String pname : propColl) {
                if (pname.compareTo("name") == 0 || pname.compareTo("description") == 0 || pname.compareTo("screenTip") == 0) {
                    if (pname.compareTo("name") == 0) {
                        pname = "defaultName";
                    }
                    if (pname.compareTo("description") == 0) {
                        pname = "defaultDescription";
                    }
                    if (pname.compareTo("screenTip") == 0) {
                        pname = "defaultScreenTip";
                    }
                    requestedPackageProperties.add(pname);
                }
                if (pname.compareTo("isNullSuppressionAllowed") != 0 && pname.compareTo("isMultiEdgeNullSuppressionAllowed") != 0 && pname.compareTo("isAccessToNullSuppressionOptionsAllowed") != 0) continue;
                requestedPackageSpecialProperties.add(pname);
            }
        }
        String[] propNames = null;
        propNames = this.issueStringProperties(requestedPackageProperties);
        MFWContentHelper hlprRCI = MFWContentHelper.create((String)this.mQueryParser.getCAMPassport(), (String)this.mQueryParser.getProductLocale(), (String)this.mQueryParser.getRunLocale(), null);
        MFWContentHelper.CMObjectInfo objInfo = hlprRCI.getCMObjectProperties(this.mQueryParser.getDataSource(), this.mPGW.getContext());
        for (int j = 0; j < propNames.length; ++j) {
            String propName = propNames[j];
            propValue = null;
            if (propName.compareTo("defaultName") == 0) {
                propName = "name";
                propValue = objInfo.getDefaultName();
                if (propValue == null) {
                    propValue = "";
                }
            }
            if (propName.compareTo("defaultDescription") == 0) {
                propName = "description";
                propValue = objInfo.getDefaultDescription();
                if (propValue == null) {
                    propValue = "";
                }
            }
            if (propName.compareTo("defaultScreenTip") == 0) {
                propName = "screenTip";
                propValue = objInfo.getDefaultScreenTip();
                if (propValue == null) {
                    propValue = "";
                }
            }
            this.mIdDOMResponseBuilder.addAttribute(elem, propName, propValue);
        }
        for (int i = 0; i < requestedPackageSpecialProperties.size(); ++i) {
            String reqPropName = (String)requestedPackageSpecialProperties.get(i);
            propValue = "";
            if (reqPropName.compareTo("isNullSuppressionAllowed") == 0 || reqPropName.compareTo("isMultiEdgeNullSuppressionAllowed") == 0 || reqPropName.compareTo("isAccessToNullSuppressionOptionsAllowed") == 0) {
                propValue = this.getSimplePropertyValue(this.getProjectNode(), MODEL_RES.getResourceID(reqPropName));
            }
            this.mIdDOMResponseBuilder.addAttribute(elem, reqPropName, propValue);
        }
    }

    private String[] issueStringProperties(ArrayList<String> propNames) {
        String[] names = new String[propNames.size()];
        for (int idx = 0; idx < propNames.size(); ++idx) {
            String aProp;
            names[idx] = aProp = propNames.get(idx);
        }
        return names;
    }

    public static String encodeSquareBrackets(String id) {
        if (id == null || id.length() == 0) {
            return "";
        }
        StringBuilder newID = null;
        int len = id.length();
        boolean found = false;
        int index = 0;
        int whitespace = 0;
        block4: for (int i = 0; i < len; ++i) {
            char ch = id.charAt(i);
            if (found) {
                switch (ch) {
                    case '.': {
                        found = false;
                        whitespace = 0;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        ++whitespace;
                        continue block4;
                    }
                    default: {
                        if (newID == null) {
                            newID = new StringBuilder(id.length() + 1);
                        }
                        newID.append(id.subSequence(index, i - whitespace));
                        newID.append(']');
                        newID.append(id.subSequence(i - whitespace, i));
                        whitespace = 0;
                        index = i;
                        found = false;
                    }
                }
            }
            if (ch != ']') continue;
            found = true;
        }
        if (newID != null) {
            newID.append(id.subSequence(index, id.length()));
            return newID.toString();
        }
        return id;
    }

    private boolean constraintsFilter(MFWNodeHandle handle) {
        if (this.mConstraintProcessor.hasConstraints()) {
            return this.mConstraintProcessor.evaluate(handle);
        }
        return true;
    }

    private MFWNodeHandle getParent(MFWNodeHandle startingHandle) {
        MFWNodeHandle parent = startingHandle.getParent();
        String name = parent.getInfo().getName();
        if (this.mPropertyParser.findCollection(name)) {
            return parent;
        }
        return null;
    }

    private ArrayList<MFWNodeHandle> getAncestors(MFWNodeHandle startingHandle) {
        MFWNodeHandle handle = startingHandle;
        ArrayList<MFWNodeHandle> ancestors = new ArrayList<MFWNodeHandle>();
        while (handle != null && (handle = handle.getParent()).getInfo().getRID() != MFWModelRes.getInstance().RID_project) {
            String name = handle.getInfo().getName();
            if (!this.mPropertyParser.findCollection(name)) continue;
            ancestors.add(0, handle);
        }
        return ancestors;
    }

    private ArrayList<MFWNodeHandle> getSiblings(MFWNodeHandle startingHandle) {
        ArrayList<MFWNodeHandle> siblings = new ArrayList<MFWNodeHandle>();
        MFWNodeHandle parent = startingHandle.getParent();
        if (parent != null) {
            MFWNodeHandle[] handles = this.mPGW.getAllObjectChildren(parent);
            for (int k = 0; k < handles.length; ++k) {
                MFWNodeHandle handle = handles[k];
                if (handle.equals((Object)startingHandle) || !this.mPropertyParser.findAllowedSibling(handle.getInfo().getName())) continue;
                if (siblings.size() == 0) {
                    siblings.add(handle);
                    continue;
                }
                siblings.add(0, handle);
            }
        }
        return siblings;
    }

    private Element processAncestorsSiblingsParentProperties(MFWNodeHandle startingHandle, Element response) {
        MFWNodeHandle handle;
        String path;
        String ref2;
        MFWNodeHandle handle2;
        int k;
        boolean parentProp = this.mPropertyParser.findVirtualProperty("_parent");
        boolean ancestorsProp = this.mPropertyParser.findVirtualProperty("_ancestors");
        boolean siblingsProp = this.mPropertyParser.findVirtualProperty("_siblings");
        short lastRefType = this.mIdManager.getLastRefType();
        short lastOrigRefType = this.mIdManager.getLastOrigRefType();
        MFWNodeHandle lastHandle = this.mIdManager.getLastHandle();
        String lastRefID = this.mIdManager.getRefID();
        String lastPathID = this.mIdManager.getPathID();
        Element elem = response;
        if (ancestorsProp) {
            ArrayList<MFWNodeHandle> ancestors = this.getAncestors(startingHandle);
            for (k = 0; k < ancestors.size(); ++k) {
                handle2 = ancestors.get(k);
                ref2 = this.mIdManager.buildRefPath(handle2);
                path = this.mIdManager.buildFullPath(handle2);
                this.mIdManager.initializePathID(path);
                this.mIdManager.initializeRefID(ref2, handle2.getInfo().getRID(), handle2.getInfo().getRID(), null);
                elem = this.processProperties(handle2, handle2, elem);
            }
        } else if (parentProp && (handle = this.getParent(startingHandle)) != null) {
            String ref22 = this.mIdManager.buildRefPath(handle);
            String path2 = this.mIdManager.buildFullPath(handle);
            this.mIdManager.initializePathID(path2);
            this.mIdManager.initializeRefID(ref22, handle.getInfo().getRID(), handle.getInfo().getRID(), null);
            elem = this.processProperties(handle, handle, elem);
        }
        if (siblingsProp) {
            ArrayList<MFWNodeHandle> siblings = this.getSiblings(startingHandle);
            for (k = 0; k < siblings.size(); ++k) {
                handle2 = siblings.get(k);
                ref2 = this.mIdManager.buildRefPath(handle2);
                path = this.mIdManager.buildFullPath(handle2);
                this.mIdManager.initializePathID(path);
                this.mIdManager.initializeRefID(ref2, handle2.getInfo().getRID(), handle2.getInfo().getRID(), null);
                this.processProperties(handle2, handle2, response);
                elem = response;
            }
        }
        this.mIdManager.initializeRefID(lastRefID, lastOrigRefType, lastRefType, lastHandle);
        this.mIdManager.initializePathID(lastPathID);
        return elem;
    }

    public String getStartingElementType() {
        return this.mRootCollectionName;
    }

    @Override
    protected String getCurrentRefId(MFWNodeHandle objectHandle) {
        return this.mIdManager.getRefID();
    }

    static {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (configuration.getBooleanProperty("ma4j.replaceInvalidXmlCharacter[@enabled]", true)) {
            replacement = configuration.getStringProperty("ma4j.replaceInvalidXmlCharacter[@value]", "");
        }
    }

    public class MAStackTargetDestinationPair {
        private Node targetNode = null;
        private Node destinationNode = null;

        public MAStackTargetDestinationPair(Node inTargetNode, Node inDestinationNode) {
            this.targetNode = inTargetNode;
            this.destinationNode = inDestinationNode;
        }
    }
}

