/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.ma4j.framework.MACollectionElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MAQueryProcessor {
    private MFWModel mModel = null;
    private Map<String, ArrayList<String>> mCollectionsSet = new HashMap<String, ArrayList<String>>();
    private ArrayList<MACollectionElement> mTrees = new ArrayList();
    private String mProject = "project";

    public MAQueryProcessor() {
        this.mModel = MFWModel.getInstance();
    }

    public MAQueryProcessor(ArrayList<String> collections) {
        this.mModel = MFWModel.getInstance();
        this.setCollections(collections);
    }

    public MAQueryProcessor(Map<String, ArrayList<String>> collections) {
        this.mModel = MFWModel.getInstance();
        this.setCollections(collections);
    }

    public void setCollections(ArrayList<String> collections) {
        this.addCollection(this.mProject);
        int size = collections.size();
        for (int k = 0; k < size; ++k) {
            this.addCollection(collections.get(k));
        }
    }

    private void addCollection(String collectionName) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(collectionName);
        this.mCollectionsSet.put(collectionName, names);
    }

    public void setCollections(Map<String, ArrayList<String>> collections) {
        this.mCollectionsSet = collections;
        this.addCollection(this.mProject);
    }

    public MACollectionElement getCollectionsTree() {
        if (this.mTrees.size() > 0) {
            return this.mTrees.get(0);
        }
        return null;
    }

    private MACollectionElement mergeSubtrees(ArrayList<String> parent, ArrayList<String> child) {
        MACollectionElement parentSubtree = this.buildSubtree(parent);
        MACollectionElement childSubtree = this.buildSubtree(child);
        MACollectionElement subtreeParent = parentSubtree;
        MACollectionElement subtreeChild = childSubtree;
        if (subtreeParent.hasChildren()) {
            while (subtreeParent.hasChildren()) {
                ArrayList<MACollectionElement> children = subtreeParent.getChildren();
                MACollectionElement elemParent = children.get(0);
                if (!elemParent.getName().equals(childSubtree.getName())) {
                    parentSubtree.addChild(childSubtree);
                    childSubtree.setParent(parentSubtree);
                    return parentSubtree;
                }
                subtreeParent = elemParent;
                if (!subtreeChild.hasChildren()) {
                    return parentSubtree;
                }
                subtreeChild = subtreeParent.getChildren().get(0);
                subtreeParent = elemParent;
            }
            return parentSubtree;
        }
        parentSubtree.addChild(childSubtree);
        childSubtree.setParent(parentSubtree);
        return parentSubtree;
    }

    private MACollectionElement buildSubtree(ArrayList<String> names) {
        MACollectionElement rootElement = null;
        MACollectionElement parentElement = null;
        for (int k = 0; k < names.size(); ++k) {
            String name = names.get(k);
            MFWInfo collInfo = this.getInfo(name);
            MACollectionElement collElement = new MACollectionElement(collInfo);
            if (k == 0) {
                rootElement = collElement;
            }
            if (this.testForSelfReference(name)) {
                collElement.setSelf(true);
            }
            if (parentElement != null) {
                collElement.setParent(parentElement);
                parentElement.addChild(collElement);
            }
            parentElement = collElement;
        }
        return rootElement;
    }

    public void buildAncestryTree(String rootCollectionName) {
        MFWInfo startInfo = this.getInfo(rootCollectionName);
        Set<String> baseNames = this.mCollectionsSet.keySet();
        this.filterCollections(baseNames, rootCollectionName, startInfo);
        if (this.mCollectionsSet.size() == 1) {
            MACollectionElement collElement = new MACollectionElement(startInfo);
            if (this.testForSelfReference(startInfo.getName())) {
                collElement.setSelf(true);
            }
            this.mTrees.add(collElement);
            return;
        }
        this.mTrees = new ArrayList();
        this.buildSubtrees(baseNames);
        this.consolidateRoots();
        this.consolidateParents();
        this.cleanupTreeStructure();
    }

    private void filterCollections(Set<String> baseNames, String rootCollectionName, MFWInfo startInfo) {
        HashMap<String, ArrayList<String>> filteredCollection = new HashMap<String, ArrayList<String>>();
        for (String collName : baseNames) {
            if (!collName.equals(rootCollectionName)) {
                MFWInfo collInfo = this.getInfo(collName);
                if (collInfo == null) continue;
                ArrayList outPathInfo = new ArrayList();
                if (!MFWModel.getInstance().canLeadTo(collInfo, (MFWInfoObject)startInfo, outPathInfo)) continue;
                ArrayList<String> names = this.mCollectionsSet.get(collName);
                filteredCollection.put(collName, names);
                continue;
            }
            ArrayList<String> names = this.mCollectionsSet.get(collName);
            filteredCollection.put(collName, names);
        }
        if (filteredCollection.size() > 0) {
            this.mCollectionsSet = new HashMap<String, ArrayList<String>>();
            this.mCollectionsSet = filteredCollection;
        }
        filteredCollection = null;
    }

    private void buildSubtrees(Set<String> baseNames) {
        baseNames = this.mCollectionsSet.keySet();
        for (String collName : baseNames) {
            ArrayList<String> childList = this.mCollectionsSet.get(collName);
            MFWInfoObject[] parents = this.getParentsFromName(collName);
            for (int k = 0; k < parents.length; ++k) {
                MFWInfoObject parent = parents[k];
                String parentName = parent.getName();
                if (parentName.equals(collName) || !baseNames.contains(parentName)) continue;
                ArrayList<String> parentList = new ArrayList<String>();
                parentList.add(parentName);
                MACollectionElement merged = this.mergeSubtrees(parentList, childList);
                this.mTrees.add(merged);
            }
        }
    }

    private void consolidateRoots() {
        int size = this.mTrees.size();
        int[] indexToErase = new int[size * size];
        for (int k = 0; k < indexToErase.length; ++k) {
            indexToErase[k] = -1;
        }
        int index = -1;
        for (int k = size - 1; k >= 0; --k) {
            boolean skipIt = false;
            for (int i = 0; i < indexToErase.length; ++i) {
                if (indexToErase[i] != k) continue;
                skipIt = true;
                break;
            }
            if (skipIt) continue;
            MACollectionElement parentToFind = this.mTrees.get(k);
            for (int m = 0; m < size; ++m) {
                if (m == k) continue;
                MACollectionElement parent = this.mTrees.get(m);
                if (parentToFind.getRid() != parent.getRid()) continue;
                parentToFind.addChildrren(parent.getChildren());
                indexToErase[++index] = m;
            }
        }
        ArrayList<MACollectionElement> consolidatedTrees = new ArrayList<MACollectionElement>();
        for (int k = 0; k < size; ++k) {
            boolean found = false;
            for (int i = 0; i < indexToErase.length; ++i) {
                if (indexToErase[i] != k) continue;
                found = true;
                break;
            }
            if (found) continue;
            consolidatedTrees.add(this.mTrees.get(k));
        }
        if (consolidatedTrees.size() > 0) {
            this.mTrees = new ArrayList();
            this.mTrees = consolidatedTrees;
        }
        consolidatedTrees = null;
    }

    private void consolidateParents() {
        int size = this.mTrees.size();
        for (int k = 0; k < size; ++k) {
            MACollectionElement parentToProcess = this.mTrees.get(k);
            for (int m = 0; m < size; ++m) {
                if (m == k) continue;
                MACollectionElement parentToAccept = this.mTrees.get(m);
                this.processChildren(parentToAccept, parentToProcess);
            }
        }
        ArrayList<MACollectionElement> consolidatedTrees = new ArrayList<MACollectionElement>();
        for (int k = 0; k < size; ++k) {
            MACollectionElement subtree = this.mTrees.get(k);
            if (subtree.isProcessed()) continue;
            consolidatedTrees.add(subtree);
        }
        if (consolidatedTrees.size() > 0) {
            this.mTrees = new ArrayList();
            this.mTrees = consolidatedTrees;
        }
        consolidatedTrees = null;
    }

    private void cleanupTreeStructure() {
        if (this.mTrees.size() > 1) {
            int k;
            ArrayList<MACollectionElement> consolidatedTrees = new ArrayList<MACollectionElement>();
            int size = this.mTrees.size();
            for (k = 0; k < size; ++k) {
                MACollectionElement element1 = this.mTrees.get(k);
                for (int i = 0; i < size; ++i) {
                    if (i == k) continue;
                    MACollectionElement element2 = this.mTrees.get(i);
                    ArrayList outPathInfo = new ArrayList();
                    if (!this.mModel.canLeadTo(element1.getInfo(), (MFWInfoObject)element2.getInfo(), outPathInfo)) continue;
                    element1.setProcessed(true);
                }
            }
            for (k = 0; k < size; ++k) {
                MACollectionElement subtree = this.mTrees.get(k);
                if (subtree.isProcessed()) continue;
                consolidatedTrees.add(subtree);
            }
            if (consolidatedTrees.size() > 0) {
                this.mTrees = new ArrayList();
                this.mTrees = consolidatedTrees;
            }
            Object var1_1 = null;
        }
    }

    private boolean testForSelfReference(String name) {
        MFWInfoObject[] parents = this.getParentsFromName(name);
        for (int k = 0; k < parents.length; ++k) {
            MFWInfoObject parent = parents[k];
            String parentName = parent.getName();
            if (!parentName.equals(name)) continue;
            return true;
        }
        return false;
    }

    private void processChildren(MACollectionElement parentToMove, MACollectionElement parentToAccept) {
        if (parentToAccept.hasChildren()) {
            ArrayList<MACollectionElement> children = parentToAccept.getChildren();
            int size = children.size();
            for (int k = 0; k < size; ++k) {
                MACollectionElement child = children.get(k);
                if (child.getRid() != parentToMove.getRid()) continue;
                child.addChildrren(parentToMove.getChildren());
                parentToMove.setProcessed(true);
                break;
            }
        }
    }

    private MFWInfo getInfo(String name) {
        short ridName = MFWModelRes.getInstance().getResourceID(name);
        return this.mModel.findInfoByRID(ridName);
    }

    private MFWInfoObject[] getParentsFromName(String name) {
        short ridName = MFWModelRes.getInstance().getResourceID(name);
        MFWInfo anInfo = this.mModel.findInfoByRID(ridName);
        return anInfo.getParents();
    }

    private String dumpTree() {
        StringBuilder str = new StringBuilder();
        int size = this.mTrees.size();
        for (int k = 0; k < size; ++k) {
            MACollectionElement root = this.mTrees.get(k);
            this.dumpChildren(root, str, 1);
        }
        return str.toString();
    }

    private void dumpChildren(MACollectionElement parent, StringBuilder str, int level) {
        this.dumpTabs(str, level);
        str.append(parent.getName());
        str.append("(");
        str.append(level);
        str.append(")");
        str.append("\n");
        if (parent.hasChildren()) {
            ArrayList<MACollectionElement> children = parent.getChildren();
            int size = children.size();
            for (int k = 0; k < size; ++k) {
                MACollectionElement child = children.get(k);
                this.dumpChildren(child, str, level + 1);
            }
        }
    }

    private void dumpTabs(StringBuilder str, int level) {
        for (int k = 0; k < level; ++k) {
            str.append(" ");
        }
    }
}

