/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.xqe.ma4j.framework.MAIDManager;
import com.cognos.xqe.ma4j.framework.MAObjectBrowser;
import com.cognos.xqe.ma4j.framework.MAShortcutProcessor;
import com.cognos.xqe.ma4j.framework.MAWorkingLocales;
import com.cognos.xqe.util.xml.XMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MAScopeRelationships
extends MAObjectBrowser {
    private static final String CLOSE_SQURE_BRACKET = "]";
    private MFWGateway mPGW = null;
    private MAIDManager mIDManager = null;
    private MAShortcutProcessor mMAShortcutProcessor = null;
    private String mLeftID = null;
    private String mRightID = null;
    private String mSlashLevel = "//level";
    private String mOpenBracket = "[";
    private String mCloseBracket = "]";
    private String mDotOpenBracket = ".[";
    private String mDot = ".";

    public MAScopeRelationships(MFWGateway pGW, MAWorkingLocales locales) {
        super(pGW, locales);
        this.mPGW = pGW;
        this.mIDManager = new MAIDManager(this.mPGW, locales);
        this.mMAShortcutProcessor = new MAShortcutProcessor(this.mPGW);
    }

    public ArrayList<ArrayList<String>> processScopeRelationship(String measureTargetID, String measureRefID, MFWNodeHandle measureHandle) {
        Map<String, ArrayList<MFWNodeHandle>> shortcutsMap = this.mMAShortcutProcessor.getShortcuts();
        ArrayList<ArrayList<String>> levelsResult = new ArrayList<ArrayList<String>>();
        Map<MFWNodeHandle, MAHierarchy> hierarchies = this.prepareHierarchies(measureTargetID, measureHandle);
        if (hierarchies != null) {
            MAHierarchy hi;
            MFWNodeHandle[] levels;
            Set<MFWNodeHandle> hierKeys = hierarchies.keySet();
            block0: for (MFWNodeHandle hierarchyHandle : hierKeys) {
                levels = this.getChildren(hierarchyHandle, this.mSlashLevel, -1);
                hi = hierarchies.get(hierarchyHandle);
                String scopeLevelID = hi.getScopeLevelID();
                boolean scopeLevelProvided = false;
                if (scopeLevelID != null) {
                    boolean bl = scopeLevelProvided = scopeLevelID.length() > 0;
                }
                if (levels == null) continue;
                for (int l = 0; l < levels.length; ++l) {
                    MFWNodeHandle level = levels[l];
                    ArrayList<String> levelsIDs = new ArrayList<String>();
                    levelsResult.add(levelsIDs);
                    String levelRefID = this.mIDManager.buildRefPath(level);
                    String levelName = this.getName(level, MAWorkingLocales.getRunLocale());
                    levelsIDs.add(levelName);
                    levelsIDs.add(levelRefID);
                    if (!scopeLevelProvided) continue;
                    String levelID = this.mIDManager.buildFullPath(level);
                    if (hi.getScopeLevelID().equals(levelID)) continue block0;
                }
            }
            block2: for (MFWNodeHandle hierarchyHandle : hierKeys) {
                levels = this.getChildren(hierarchyHandle, this.mSlashLevel, -1);
                hi = hierarchies.get(hierarchyHandle);
                MFWNodeHandle dimensionHandle = this.getParentDimension(hierarchyHandle);
                String scopeLevelIDShortcut = hi.getScopeLevelIDShortcut();
                boolean scopeLevelShortcutProvided = false;
                if (scopeLevelIDShortcut != null) {
                    scopeLevelShortcutProvided = scopeLevelIDShortcut.length() > 0;
                }
                ArrayList<Object> hierarchyHandleShortcuts = new ArrayList();
                String hierarcyRefID = this.mIDManager.buildRefPath(dimensionHandle);
                hierarchyHandleShortcuts = shortcutsMap.get(hierarcyRefID);
                MFWNodeHandle parentNamespace = this.getParentNamespace(dimensionHandle);
                String parentNamespaceRefID = this.mIDManager.buildRefPath(parentNamespace);
                ArrayList<MFWNodeHandle> parentNamespaceShortcuts = shortcutsMap.get(parentNamespaceRefID);
                ArrayList<MFWNodeHandle> parentNamespaceOfHierarchyShortcuts = new ArrayList<MFWNodeHandle>();
                if (hierarchyHandleShortcuts != null) {
                    int size = hierarchyHandleShortcuts.size();
                    for (int s = 0; s < size; ++s) {
                        MFWNodeHandle hierarchyShortcut = (MFWNodeHandle)hierarchyHandleShortcuts.get(s);
                        MFWNodeHandle parentNamespaceOfShortcut = this.getParentNamespace(hierarchyShortcut);
                        String parentNamespaceOfShortcutRefID = this.mIDManager.buildRefPath(parentNamespaceOfShortcut);
                        if (!shortcutsMap.containsKey(parentNamespaceOfShortcutRefID)) continue;
                        parentNamespaceOfHierarchyShortcuts.add(parentNamespaceOfShortcut);
                    }
                }
                if (levels == null) continue;
                for (int l = 0; l < levels.length; ++l) {
                    int k;
                    MFWNodeHandle level = levels[l];
                    ArrayList<String> levelsIDs = new ArrayList<String>();
                    levelsResult.add(levelsIDs);
                    String levelRefID = this.mIDManager.buildRefPath(level);
                    String levelName = this.getName(level, MAWorkingLocales.getRunLocale());
                    levelsIDs.add(levelName);
                    if (hierarchyHandleShortcuts != null) {
                        for (k = 0; k < hierarchyHandleShortcuts.size(); ++k) {
                            MFWNodeHandle hierarchyHandleShortcut = (MFWNodeHandle)hierarchyHandleShortcuts.get(k);
                            String hierShortcutName = this.getName(hierarchyHandleShortcut, MAWorkingLocales.getRefLocale(this.getUseDesignLocaleForReferenceID()));
                            MFWNodeHandle parentNamespaceOfShortcut = this.getParentNamespace(hierarchyHandleShortcut);
                            String parentNamespaceOfShortcutName = this.getName(parentNamespaceOfShortcut, MAWorkingLocales.getRefLocale(this.getUseDesignLocaleForReferenceID()));
                            StringBuilder firstTwo = new StringBuilder();
                            firstTwo.append(this.mOpenBracket);
                            firstTwo.append(parentNamespaceOfShortcutName);
                            firstTwo.append(this.mCloseBracket);
                            firstTwo.append(this.mDotOpenBracket);
                            firstTwo.append(hierShortcutName);
                            firstTwo.append(this.mCloseBracket);
                            String newLeveRefIdHierShortcut = this.updateIDfirstTwoTokens(levelRefID, firstTwo.toString());
                            levelsIDs.add(newLeveRefIdHierShortcut);
                        }
                    }
                    if (hierarchyHandleShortcuts != null) {
                        int size = hierarchyHandleShortcuts.size();
                        for (int s = 0; s < size; ++s) {
                            ArrayList<MFWNodeHandle> shortcutsParentNamespaceShortcuts;
                            MFWNodeHandle hierarchyShortcut = (MFWNodeHandle)hierarchyHandleShortcuts.get(s);
                            String hierShortcutName = this.getName(hierarchyShortcut, MAWorkingLocales.getRefLocale(this.getUseDesignLocaleForReferenceID()));
                            MFWNodeHandle parentNamespaceOfShortcut = this.getParentNamespace(hierarchyShortcut);
                            String parentNamespaceOfShortcutRefID = this.mIDManager.buildRefPath(parentNamespaceOfShortcut);
                            if (!shortcutsMap.containsKey(parentNamespaceOfShortcutRefID) || (shortcutsParentNamespaceShortcuts = shortcutsMap.get(parentNamespaceOfShortcutRefID)) == null) continue;
                            for (int k2 = 0; k2 < shortcutsParentNamespaceShortcuts.size(); ++k2) {
                                MFWNodeHandle shortcutsParentNamespaceShortcut = shortcutsParentNamespaceShortcuts.get(k2);
                                String shortcutsParentNamespaceShortcutName = this.getName(shortcutsParentNamespaceShortcut, MAWorkingLocales.getRefLocale(this.getUseDesignLocaleForReferenceID()));
                                StringBuilder firstTwo = new StringBuilder();
                                firstTwo.append(this.mOpenBracket);
                                firstTwo.append(shortcutsParentNamespaceShortcutName);
                                firstTwo.append(this.mCloseBracket);
                                firstTwo.append(this.mDotOpenBracket);
                                firstTwo.append(hierShortcutName);
                                firstTwo.append(this.mCloseBracket);
                                String newLeveRefIdHierShortcut = this.updateIDfirstTwoTokens(levelRefID, firstTwo.toString());
                                levelsIDs.add(newLeveRefIdHierShortcut);
                            }
                        }
                    }
                    if (parentNamespaceShortcuts != null) {
                        for (k = 0; k < parentNamespaceShortcuts.size(); ++k) {
                            MFWNodeHandle parentHierarchyHandleShortcut = parentNamespaceShortcuts.get(k);
                            String parentNamespaceOfShortcutName = this.getName(parentHierarchyHandleShortcut, MAWorkingLocales.getRefLocale(this.getUseDesignLocaleForReferenceID()));
                            String newLeveRefIdHierShortcut = this.updateID(levelRefID, parentNamespaceOfShortcutName, 0);
                            levelsIDs.add(newLeveRefIdHierShortcut);
                        }
                    }
                    if (!scopeLevelShortcutProvided) continue;
                    String levelID = this.mIDManager.buildFullPath(level);
                    if (hi.getScopeLevelIDShortcut().equals(levelID)) continue block2;
                }
            }
        }
        return levelsResult;
    }

    private String updateID(String id, String newToken, int tokenIndex) {
        ArrayList<String> tokens = this.mIDManager.splitID(id);
        StringBuilder newId = new StringBuilder();
        for (int k = 0; k < tokens.size(); ++k) {
            String token = tokens.get(k);
            if (newId.length() > 0) {
                newId.append(this.mDot);
            }
            if (k == tokenIndex) {
                newId.append(this.mOpenBracket);
                newId.append(newToken);
                newId.append(this.mCloseBracket);
                continue;
            }
            newId.append(token);
        }
        return newId.toString();
    }

    private String updateIDfirstTwoTokens(String id, String firstTwoTokens) {
        ArrayList<String> tokens = this.mIDManager.splitID(id);
        StringBuilder newId = new StringBuilder();
        newId.append(firstTwoTokens);
        for (int k = 2; k < tokens.size(); ++k) {
            newId.append(this.mDot);
            String token = tokens.get(k);
            newId.append(token);
        }
        return newId.toString();
    }

    public Map<MFWNodeHandle, MAHierarchy> prepareHierarchies(String measureID, MFWNodeHandle measureHandle) {
        HashMap<MFWNodeHandle, MAHierarchy> hierarchies = new HashMap<MFWNodeHandle, MAHierarchy>();
        MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)"//scopeRelationship");
        aQuerySpec.setRetrievalDepth(-1);
        MFWNodeHandle[] handles = null;
        handles = this.mPGW.query(aQuerySpec);
        for (int k = 0; k < handles.length; ++k) {
            MFWNodeHandle handle = handles[k];
            if (handle == null) continue;
            this.getLeftAndRightRefIDs(handle);
            MFWNodeHandle leftTarget = null;
            MFWNodeHandle rightTarget = null;
            MFWNodeHandle left = this.getHandleByID(null, this.mLeftID);
            MFWNodeHandle right = this.getHandleByID(null, this.mRightID);
            if (left == null || right == null) continue;
            leftTarget = this.mMAShortcutProcessor.processShortcuts(left);
            rightTarget = this.mMAShortcutProcessor.processShortcuts(right);
            MFWNodeHandle leftResolved = leftTarget;
            if (leftTarget == null) {
                leftResolved = left;
            }
            MFWNodeHandle rightResolved = rightTarget;
            if (rightTarget == null) {
                rightResolved = right;
            }
            MFWNodeHandle[] leftHierarchies = this.getChildren(leftResolved, "hierarchy", 1);
            MFWNodeHandle[] rightMeasures = this.getChildren(rightResolved, "//measure", -1);
            if (rightMeasures == null) continue;
            boolean foundMeasure = false;
            for (int m = 0; m < rightMeasures.length; ++m) {
                MFWNodeHandle rightMeasure = rightMeasures[m];
                String rightMeasureID = this.mIDManager.buildRefPath(rightMeasure);
                if (!measureID.equals(rightMeasureID)) continue;
                foundMeasure = true;
                break;
            }
            if (!foundMeasure) continue;
            String scopeLevelID = null;
            boolean measureExcluded = false;
            HashMap<MFWNodeHandle, MAHierarchy> scopeRules = new HashMap<MFWNodeHandle, MAHierarchy>();
            MFWNodeHandle[] scopes = this.getChildren(handle, "scope", 1);
            if (scopes != null) {
                for (int s = 0; s < scopes.length; ++s) {
                    MFWNodeHandle scope = scopes[s];
                    MFWNodeHandle[] measureScopes = this.getChildren(scope, "measureScope", 1);
                    if (measureScopes == null) continue;
                    for (int ms = 0; ms < measureScopes.length; ++ms) {
                        String scopeMeasureID;
                        MFWNodeHandle measureScope = measureScopes[ms];
                        String excluded = this.getProperty(measureScope, "excluded", false, MAWorkingLocales.getRunLocale());
                        MFWNodeHandle refobj = this.getChild(measureScope, "refobj");
                        if (refobj == null || !measureID.equals(scopeMeasureID = this.getValue(refobj, false))) continue;
                        MFWNodeHandle scopeLevel = this.getChild(scope, "levelRef");
                        if (scopeLevel != null) {
                            scopeLevelID = this.getValue(scopeLevel, false);
                        }
                        measureExcluded = !"false".equals(excluded);
                        MAHierarchy scopeRule = (MAHierarchy)scopeRules.get(leftResolved);
                        if (scopeRule == null) {
                            scopeRule = new MAHierarchy(left, scopeLevelID, measureExcluded, leftTarget != null);
                            scopeRules.put(leftResolved, scopeRule);
                            continue;
                        }
                        scopeRule.setAll(left, scopeLevelID, measureExcluded, leftTarget != null);
                    }
                }
            }
            if (leftHierarchies == null) continue;
            for (int h = 0; h < leftHierarchies.length; ++h) {
                MFWNodeHandle hierarchy = leftHierarchies[h];
                if (this.hierarchyIsExcluded(hierarchy, scopeRules)) continue;
                Set keys = scopeRules.keySet();
                Iterator it = keys.iterator();
                if (it.hasNext()) {
                    MFWNodeHandle dim = (MFWNodeHandle)it.next();
                    MAHierarchy hierarchyInfo = (MAHierarchy)scopeRules.get(dim);
                    MAHierarchy oldRule = (MAHierarchy)hierarchies.get(hierarchy);
                    if (oldRule == null) {
                        hierarchies.put(hierarchy, hierarchyInfo);
                        continue;
                    }
                    if (leftTarget != null) {
                        oldRule.setAll(left, hierarchyInfo.getScopeLevelIDShortcut(), hierarchyInfo.getExculdedShortcut(), leftTarget != null);
                        continue;
                    }
                    oldRule.setAll(left, hierarchyInfo.getScopeLevelID(), hierarchyInfo.getExculded(), leftTarget != null);
                    continue;
                }
                MAHierarchy maHierarchy = new MAHierarchy(left, "", false, leftTarget != null);
                hierarchies.put(hierarchy, maHierarchy);
            }
        }
        return hierarchies;
    }

    private void getLeftAndRightRefIDs(MFWNodeHandle scopeRelationshipHandle) {
        MFWNodeHandle leftRefObj = this.getChild(scopeRelationshipHandle, "leftrefobj");
        MFWNodeHandle rightRefObj = this.getChild(scopeRelationshipHandle, "rightrefobj");
        this.mLeftID = this.getValue(leftRefObj, false);
        this.mRightID = this.getValue(rightRefObj, false);
    }

    private MFWNodeHandle getChild(MFWNodeHandle parent, String queryPath) {
        MFWNodeHandle child = null;
        MFWNodeHandle[] handles = this.getChildren(parent, queryPath, 1);
        if (handles != null && handles.length > 0) {
            child = handles[0];
        }
        return child;
    }

    private MFWNodeHandle[] getChildren(MFWNodeHandle parent, String queryPath, int depth) {
        MFWNodeHandle[] handles = null;
        MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)queryPath);
        aQuerySpec.setRetrievalDepth(depth);
        handles = parent == null ? this.mPGW.query(aQuerySpec) : this.mPGW.queryObject(parent, aQuerySpec);
        return handles;
    }

    private MFWNodeHandle getHandleByID(MFWNodeHandle parent, String id) {
        MFWNodeHandle[] handles = null;
        String queryPath = new String("//*[ID=" + XMLUtils.xPathLiteral(id) + CLOSE_SQURE_BRACKET);
        MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)queryPath);
        handles = parent != null ? this.mPGW.queryObject(parent, aQuerySpec) : this.mPGW.query(aQuerySpec);
        if (handles != null) {
            return handles[0];
        }
        return null;
    }

    private boolean hierarchyIsExcluded(MFWNodeHandle hierarchyHandle, Map<MFWNodeHandle, MAHierarchy> scopeRules) {
        String hierarchyID = this.mIDManager.buildRefPath(hierarchyHandle);
        Set<MFWNodeHandle> keys = scopeRules.keySet();
        for (MFWNodeHandle hier : keys) {
            MAHierarchy hierarchyInfo = scopeRules.get(hier);
            String scopeLevelID = hierarchyInfo.getScopeLevelID();
            boolean excluded = hierarchyInfo.getExculded();
            if (!excluded || !hierarchyID.equals(scopeLevelID)) continue;
            return true;
        }
        return false;
    }

    protected class MAHierarchy
    extends MAHierarchyInfo {
        private MFWNodeHandle mHierarchyHandle;
        private MFWNodeHandle mHierarchyHandleTarget;

        public MAHierarchy(MFWNodeHandle hierarchyHandle, String scopeLevelID, boolean excluded, boolean dimensionShortcut) {
            super(scopeLevelID, excluded, dimensionShortcut);
            this.mHierarchyHandle = null;
            this.mHierarchyHandleTarget = null;
            if (dimensionShortcut) {
                this.mHierarchyHandleTarget = MAScopeRelationships.this.mMAShortcutProcessor.processShortcuts(hierarchyHandle);
                this.mHierarchyHandle = hierarchyHandle;
            } else {
                this.mHierarchyHandleTarget = hierarchyHandle;
            }
        }

        public MAHierarchy(MAHierarchy hierarchy) {
            this.mHierarchyHandle = null;
            this.mHierarchyHandleTarget = null;
            this.setExcluded(hierarchy.getExculded());
            this.setExcludedShortcut(hierarchy.getExculdedShortcut());
            this.setScopeLevelID(hierarchy.getScopeLevelID());
            this.setScopeLevelIDShortcut(hierarchy.getScopeLevelIDShortcut());
            this.setHierarchyHandle(hierarchy.getHierarchyHandle());
            this.setHierarchyHandleTarget(hierarchy.getHierarchyHandleTarget());
        }

        public MFWNodeHandle getHierarchyHandle() {
            return this.mHierarchyHandle;
        }

        public MFWNodeHandle getHierarchyHandleTarget() {
            return this.mHierarchyHandleTarget;
        }

        public void setHierarchyHandle(MFWNodeHandle handle) {
            this.mHierarchyHandle = handle;
        }

        public void setHierarchyHandleTarget(MFWNodeHandle handle) {
            this.mHierarchyHandleTarget = handle;
        }

        public void setAll(MFWNodeHandle hierarchyHandle, String scopeLevelID, boolean excluded, boolean dimensionShortcut) {
            super.setAll(scopeLevelID, excluded, dimensionShortcut);
            if (dimensionShortcut) {
                this.mHierarchyHandleTarget = MAScopeRelationships.this.mMAShortcutProcessor.processShortcuts(hierarchyHandle);
                this.mHierarchyHandle = hierarchyHandle;
            } else {
                this.mHierarchyHandleTarget = hierarchyHandle;
            }
        }
    }

    protected class MAHierarchyInfo {
        private String mScopeLevelID = null;
        private String mScopeLevelIDShortcut = null;
        private boolean mExcluded = false;
        private boolean mExcludedShortcut = false;

        public MAHierarchyInfo() {
        }

        public MAHierarchyInfo(String scopeLevelID, boolean excluded, boolean dimensionShortcut) {
            this.setAll(scopeLevelID, excluded, dimensionShortcut);
        }

        public MAHierarchyInfo(MAHierarchyInfo hierarchyInfo) {
            this.setExcluded(hierarchyInfo.getExculded());
            this.setExcludedShortcut(hierarchyInfo.getExculdedShortcut());
            this.setScopeLevelID(hierarchyInfo.getScopeLevelID());
            this.setScopeLevelIDShortcut(hierarchyInfo.getScopeLevelIDShortcut());
        }

        public String getScopeLevelID() {
            return this.mScopeLevelID;
        }

        public boolean getExculded() {
            return this.mExcluded;
        }

        public String getScopeLevelIDShortcut() {
            return this.mScopeLevelIDShortcut;
        }

        public boolean getExculdedShortcut() {
            return this.mExcludedShortcut;
        }

        public void setScopeLevelID(String id) {
            this.mScopeLevelID = id;
        }

        public void setScopeLevelIDShortcut(String id) {
            this.mScopeLevelIDShortcut = id;
        }

        public void setExcluded(boolean excluded) {
            this.mExcluded = excluded;
        }

        public void setExcludedShortcut(boolean excluded) {
            this.mExcludedShortcut = excluded;
        }

        public boolean hasShortcutRule() {
            return this.mScopeLevelIDShortcut != null;
        }

        public void setAll(String scopeLevelID, boolean excluded, boolean dimensionShortcut) {
            if (dimensionShortcut) {
                this.mScopeLevelIDShortcut = scopeLevelID;
                this.mExcludedShortcut = excluded;
            } else {
                this.mScopeLevelID = scopeLevelID;
                this.mExcluded = excluded;
            }
        }
    }
}

