/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.ast.XQEUberNodeFactory;
import com.cognos.xqe.ast.macro.MXNodeFactory;
import com.cognos.xqe.ast.v5.V5NodeFactory;
import com.cognos.xqe.ast.v5Exp.V5ExpNodeFactory;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.ma4j.framework.MAConstraintProcessor;
import com.cognos.xqe.ma4j.framework.MAMetadataParameters;
import com.cognos.xqe.ma4j.framework.MAQueryExecutor;
import com.cognos.xqe.ma4j.framework.MAQueryInfo;
import com.cognos.xqe.ma4j.framework.MAQueryParser;
import com.cognos.xqe.ma4j.framework.MAWorkingLocales;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.ma.XMACollection;
import com.cognos.xqe.runtree.ma.XMAGlobalProperty;
import com.cognos.xqe.runtree.ma.XMAQuery;
import com.cognos.xqe.runtree.ma.XMARequest;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.xml.XMLUtils;
import com.cognos.xqeqte.QTEQueryNode;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MAXQEBridge {
    private XMAQuery mXmaQuery = null;
    private MAQueryParser queryParser = null;
    private MAQueryExecutor mQueryExecutor = null;
    private MAQueryInfo mQueryInfo = null;
    private XDataContext mContext = null;
    private MAMetadataParameters metadataParameters = null;
    private MAConstraintProcessor constraintProcessor = null;
    private static final String RESPONSE = "response";
    private static final String RESPONSE_ROOT = "ResponseRoot";
    private String folder = "folder";
    private String namespace = "namespace";
    MFWGateway mGateway = null;

    public MAXQEBridge(XMAQuery xmaQuery, XDataContext context) {
        this.mXmaQuery = xmaQuery;
        this.mContext = context;
        this.queryParser = new MAQueryParser();
        this.mQueryInfo = new MAQueryInfo();
    }

    public Document processQuery() {
        this.initializeMAFromXQERuntree();
        Document responseElement = null;
        this.mQueryExecutor = new MAQueryExecutor(this.mGateway, this.queryParser, this.constraintProcessor, ((ExecutionEnvironment)this.mContext.getEnvironment()).getPAC());
        this.mQueryExecutor.executeQuery();
        if (this.checkForMUNInStart()) {
            responseElement = DocumentHelper.createDocument();
            Element response = responseElement.addElement(RESPONSE);
            response.addElement(RESPONSE_ROOT);
        } else {
            responseElement = this.mQueryExecutor.getResponseDOM();
        }
        return responseElement;
    }

    public String getStartAtRef() {
        return this.mQueryExecutor.getStartAtRef();
    }

    public String getStartingElementType() {
        if (this.mQueryExecutor != null) {
            return this.mQueryExecutor.getStartingElementType();
        }
        return null;
    }

    private void initializeMAFromXQERuntree() {
        this.metadataParameters = new MAMetadataParameters();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        this.mQueryInfo.setRunLocale(LocaleConverter.toString(reqEnv.getRunLocale()));
        this.mQueryInfo.setProductLocale(LocaleConverter.toString(reqEnv.getProductLocale()));
        this.mQueryInfo.setCAMPassport(reqEnv.getCAMPassport());
        int depth = this.mXmaQuery.getDepth();
        this.metadataParameters.setDepth(depth);
        String startAtRef = this.mXmaQuery.getStartAtRef();
        this.mQueryInfo.setInitialStartAtRef(startAtRef);
        if (null != startAtRef && (startAtRef.contains("]->:[") || startAtRef.contains("]->["))) {
            startAtRef = UniqueNameGenerator.extractLeftPartFromCognosMUN(startAtRef);
        }
        String startAtPath = this.mXmaQuery.getStartAt();
        this.mQueryInfo.setInitialStartAtPath(startAtPath);
        if (null != startAtPath && (startAtPath.contains("]->:[") || startAtPath.contains("]->["))) {
            startAtPath = UniqueNameGenerator.extractLeftPartFromCognosMUN(startAtPath);
        }
        this.mQueryInfo.setAuthoringLocale(this.mXmaQuery.getAuthoringLocale());
        this.mQueryInfo.setStartAtPath(startAtPath);
        this.mQueryInfo.setStartAtRef(startAtRef);
        if (this.mXmaQuery.getType() == 501118) {
            this.mQueryInfo.setIsFunction(true);
        }
        String enumLabels = this.mXmaQuery.getEnumLabels();
        this.metadataParameters.addAttributeProperty("_enumLabels", enumLabels);
        String generateV5 = this.mXmaQuery.getGenerateV5();
        this.metadataParameters.addAttributeProperty("GenerateV5", generateV5);
        String hasPaths = this.mXmaQuery.getMultiplePathsFlag();
        this.metadataParameters.addAttributeProperty("hasMultipleStartPaths", hasPaths);
        IXQEQueryNode iXqeQueryNode = this.mXmaQuery.getAncestorOfType(501108);
        if (iXqeQueryNode != null) {
            XMARequest requestNode = (XMARequest)iXqeQueryNode;
            String connectionString = requestNode.getModelPath();
            String updatedConnectionString = null;
            String packagePath = null;
            if (null != connectionString && connectionString.length() > 0) {
                if (connectionString.indexOf("@") == -1) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("/content/package[@name=");
                    buffer.append(XMLUtils.xPathLiteral(connectionString));
                    buffer.append("]");
                    packagePath = buffer.toString();
                    buffer.append("/model[last()]");
                    updatedConnectionString = buffer.toString();
                } else {
                    updatedConnectionString = connectionString;
                    int index = connectionString.indexOf("]/model");
                    packagePath = index != -1 ? connectionString.substring(0, index + 1) : connectionString;
                }
            }
            this.mQueryInfo.setDataSource(packagePath);
            this.mQueryInfo.setModelSearchPath(updatedConnectionString);
        }
        Set<String> internalProperties = this.mXmaQuery.getInternalProperties();
        this.appendInternalProperties(internalProperties);
        Set<String> queryHintProperties = this.mXmaQuery.getQueryHintProperties();
        this.appendPlainProperties(queryHintProperties);
        this.mGateway = (MFWGateway)this.mContext.getProperty("gateway");
        this.metadataParameters.addQueryInfo(this.mQueryInfo);
        this.getProperties();
        this.queryParser.initialize(this.metadataParameters);
        if (this.mGateway != null) {
            this.queryParser.calcEffectiveAuthoringLocales(this.mGateway);
        }
        this.prepareConstraints();
    }

    private void appendInternalProperties(Set<String> properties) {
        if (properties != null) {
            Iterator<String> it = properties.iterator();
            while (it.hasNext()) {
                String name = "_" + it.next();
                this.metadataParameters.addInternalProperty(name);
            }
        }
    }

    private void appendPlainProperties(Set<String> properties) {
        if (properties != null) {
            for (String name : properties) {
                this.metadataParameters.addPlainProperty(name);
            }
        }
    }

    private void prepareConstraints() {
        MAWorkingLocales workingLocales = this.queryParser.getWorkingLocales();
        String effectLocale = workingLocales.getEffectiveLocale();
        this.constraintProcessor = new MAConstraintProcessor(this.mGateway);
        this.constraintProcessor.buildCOnstraintsTreeFromConstraintRunTree(this.mXmaQuery, this.mContext, effectLocale);
    }

    private void getProperties() {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = this.mXmaQuery.getChildren()) {
            this.processChildNode(child);
        }
    }

    private void browseCollection(XMACollection collection) {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = collection.getChildren()) {
            this.processChildNode(child);
        }
    }

    private void processChildNode(IXQEQueryNode child) {
        if (child instanceof XMACollection) {
            XMACollection childCollection = (XMACollection)child;
            String collectionName = childCollection.getName();
            if (collectionName.equals(this.namespace)) {
                collectionName = this.folder;
            }
            this.metadataParameters.addCollection(collectionName);
            String[] propNames = childCollection.getMaProperties();
            this.appendRestrictedProperties(collectionName, propNames);
            this.browseCollection(childCollection);
        }
        if (child instanceof XMAGlobalProperty) {
            XMAGlobalProperty globalProperty = (XMAGlobalProperty)child;
            String globalName = globalProperty.getName();
            this.metadataParameters.addGlobalProperty(globalName);
        }
    }

    private void appendRestrictedProperties(String collectionName, String[] propNames) {
        for (int k = 0; k < propNames.length; ++k) {
            String propertyName = propNames[k];
            if (propertyName.equals("sources")) {
                propertyName = "dataSourceRef";
            }
            if (propertyName.equals("*")) {
                this.getAllPropertiesNames(collectionName);
                continue;
            }
            this.metadataParameters.addRestrictedProperty(collectionName, propertyName);
        }
    }

    private void getAllPropertiesNames(String collectionName) {
        short rid;
        MFWModel mfwModel = MFWModel.getInstance();
        MFWInfo info = mfwModel.findInfoByRID(rid = MFWModelRes.getInstance().getResourceID(collectionName));
        if (info != null) {
            MFWInfo[] childInfos;
            if (info.getName().equals(this.namespace) || info.getName().equals(this.folder)) {
                this.metadataParameters.addRestrictedProperty(collectionName, "isNamespace");
            }
            if ((childInfos = ((MFWInfoObject)info).getChildrenInfo()).length > 0) {
                for (int i = 0; i < childInfos.length; ++i) {
                    MFWInfo childInfo = childInfos[i];
                    if (childInfo.getNodeType() != 1 && childInfo.getRID() != MFWModelRes.getInstance().RID_name && childInfo.getRID() != MFWModelRes.getInstance().RID_description && childInfo.getRID() != MFWModelRes.getInstance().RID_screenTip && childInfo.getRID() != MFWModelRes.getInstance().RID_rootCaption && childInfo.getRID() != MFWModelRes.getInstance().RID_dimensions && childInfo.getRID() != MFWModelRes.getInstance().RID_hierarchies) continue;
                    this.metadataParameters.addRestrictedProperty(collectionName, childInfo.getName());
                }
            }
        }
    }

    private boolean checkForMUNInStart() {
        String startAtPath = this.mQueryInfo.getInitialStartAtPath();
        String startAtRef = this.mQueryInfo.getInitialStartAtRef();
        if (startAtPath != null && startAtPath.length() > 0) {
            return this.checkForMUNInStart(startAtPath);
        }
        if (startAtRef != null && startAtRef.length() > 0) {
            return this.checkForMUNInStart(startAtRef);
        }
        return false;
    }

    private boolean checkForMUNInStart(String startPoint) {
        if (startPoint.indexOf("->") == -1) {
            return false;
        }
        QTEQueryNode node = null;
        try {
            Locale expressionLocale = LocaleConverter.strToLocale(this.mQueryInfo.getAuthoringLocale());
            PlanningEnvironment planEnv = this.getPlanningEnvironment();
            node = V5ExpressionProcessor.parse(startPoint, planEnv, expressionLocale);
        }
        catch (XQERuntimeException xQERuntimeException) {
            // empty catch block
        }
        return node != null && node.getType() == 201028;
    }

    private PlanningEnvironment getPlanningEnvironment() {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(execEnv.getRequestEnvironment());
        XQETrace trace = new XQETrace();
        XQEIDGenerator idGenerator = new XQEIDGenerator();
        XQEUberNodeFactory nodeFactory = new XQEUberNodeFactory();
        nodeFactory.addNodeFactory(new V5NodeFactory());
        nodeFactory.addNodeFactory(new V5ExpNodeFactory());
        nodeFactory.addNodeFactory(new MXNodeFactory());
        nodeFactory.setNodeIDGenerator(idGenerator);
        nodeFactory.setTrace(trace);
        nodeFactory.setPlanningEnvironment(planEnv);
        planEnv.setTrace(trace);
        planEnv.setNodeFactory(nodeFactory);
        return planEnv;
    }
}

