/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.utilities;

import com.cognos.xqe.ma4j.framework.IMAAttributeTransformer;
import com.cognos.xqe.ma4j.utilities.MAXMLResponseBuilder;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class MADOMResponseBuilder {
    private IMAAttributeTransformer mAttributeTransformer = null;
    private Document mDoc = null;
    private Element mRoot = null;
    private Element mResponse = null;
    private Element mResponseRoot = null;

    public MADOMResponseBuilder() {
    }

    public MADOMResponseBuilder(Document doc) {
        this.mDoc = doc;
    }

    public IMAAttributeTransformer getAttributeTransformer() {
        return this.mAttributeTransformer;
    }

    public void setAttributeTransformer(IMAAttributeTransformer attributeTransformer) {
        this.mAttributeTransformer = attributeTransformer;
    }

    public void initialize() {
        this.buildResponseDOM();
        this.buildResponseHeader();
    }

    public Document buildResponseDOM() {
        this.mDoc = null;
        this.mDoc = DocumentHelper.createDocument();
        return this.mDoc;
    }

    public Element createElement(Branch parent, String name) {
        Element elem = null;
        if (this.mDoc != null && parent != null) {
            elem = DocumentHelper.createElement((String)name);
            parent.add(elem);
        }
        return elem;
    }

    public void addAttribute(Element parent, String name, String value) {
        if (null == (value = this.transformAttributeValue(name, value))) {
            return;
        }
        Attribute attr = parent.attribute(name);
        if (attr == null) {
            parent.addAttribute(name, value);
        } else {
            attr.setValue(value);
        }
    }

    public Text createTextNode(Element parent, String text) {
        Text textNode = null;
        if (this.mDoc != null) {
            if (text == null) {
                text = "";
            }
            textNode = DocumentHelper.createText((String)text);
            parent.add(textNode);
        }
        return textNode;
    }

    public void buildResponseHeader() {
        if (this.mDoc != null) {
            this.mResponse = this.mRoot = this.createElement((Branch)this.mDoc, "response");
            Element connID = this.createElement((Branch)this.mResponse, "connectionID");
            this.addAttribute(connID, "value", "***");
            this.mResponseRoot = this.createElement((Branch)this.mResponse, "ResponseRoot");
        }
    }

    public Element getResponseRoot() {
        return this.mResponseRoot;
    }

    public void setResponseRoot(Element elem) {
        this.mResponseRoot = elem;
    }

    public Document getResponseDOM() {
        return this.mDoc;
    }

    public String toString() {
        MAXMLResponseBuilder xmlBuilder = new MAXMLResponseBuilder();
        xmlBuilder.setAttributeTransformer(this.mAttributeTransformer);
        xmlBuilder.buildResponseHeader();
        if (this.mDoc != null && this.mResponseRoot != null) {
            this.browse((Node)this.mResponseRoot, xmlBuilder);
        }
        xmlBuilder.buildResponseFooter();
        return xmlBuilder.getXML();
    }

    private String transformAttributeValue(String attributeName, String attributeValue) {
        if (null != this.mAttributeTransformer) {
            return this.mAttributeTransformer.transform(attributeName, attributeValue);
        }
        return attributeValue;
    }

    private void browse(Node node, MAXMLResponseBuilder xmlBuilder) {
        String text;
        if (node.getNodeType() == 1) {
            List children = ((Element)node).elements();
            int len = children.size();
            for (int k = 0; k < len; ++k) {
                Node child = (Node)children.get(k);
                if (child.getNodeType() == 1) {
                    this.dumpParams(child, xmlBuilder);
                    this.browse(child, xmlBuilder);
                    String localName = child.getName();
                    xmlBuilder.addElement(localName, 2);
                    continue;
                }
                if (child.getNodeType() != 3) continue;
                this.browse(child, xmlBuilder);
            }
        } else if (node.getNodeType() == 3 && (text = node.getStringValue()) != null) {
            xmlBuilder.addText(text);
        }
    }

    private void dumpParams(Node node, MAXMLResponseBuilder xmlBuilder) {
        if (node.getNodeType() == 1) {
            String localName = node.getName();
            int nAttributes = ((Element)node).attributeCount();
            if (nAttributes > 0) {
                xmlBuilder.addElement(localName, 0);
                for (int k = 0; k < nAttributes; ++k) {
                    Attribute attrNode = ((Element)node).attribute(k);
                    String name = attrNode.getName();
                    String value = attrNode.getValue();
                    xmlBuilder.addAttribute(name, value);
                }
                xmlBuilder.endElement(false);
            } else {
                xmlBuilder.addElement(localName, 1);
            }
        }
    }

    public static String dumpElement(Element elem) {
        try {
            OutputFormat format = new OutputFormat();
            format.setSuppressDeclaration(true);
            format.setOmitEncoding(true);
            StringWriter output = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)output, format);
            writer.write(elem);
            return output.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

